% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{convert_polyRAD}
\alias{convert_polyRAD}
\title{Convert (probabilistic) genotype calling results from polyRAD to input compatible with polymapR}
\usage{
convert_polyRAD(RADdata)
}
\arguments{
\item{RADdata}{An RADdata (S3 class) object; output of the function \link[polyRAD]{PipelineMapping2Parents} having followed
the prior steps needed in the polyRAD pipeline. See the polyRAD vignette for details.}
}
\value{
A data frame which include columns: 
MarkerName, SampleName,P0 ~ Pploidy (e.g. P0 ~ P4 for tetraploid, which represents
the probability assigning to this dosage), maxgeno (the most likely dosage),
and maxP (the maximum probability)
}
\description{
Convert (probabilistic) genotype calling results from polyRAD to input compatible with polymapR
}
\examples{
data("exampleRAD_mapping")
convert_polyRAD(RADdata = exampleRAD_mapping)
}
