% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plasso.R
\name{plot.plasso}
\alias{plot.plasso}
\title{Plot coefficient paths}
\usage{
\method{plot}{plasso}(x, ..., lasso = FALSE, xvar = c("norm", "lambda", "dev"), label = FALSE)
}
\arguments{
\item{x}{\code{\link{plasso}} object}

\item{...}{Pass generic \code{\link[base]{plot}} options}

\item{lasso}{If set as True, coefficient paths for Lasso instead of Post-Lasso is plotted. Default is False.}

\item{xvar}{X-axis variable:
\code{norm} plots against the L1-norm of the coefficients,
\code{lambda} against the log-lambda sequence,
and \code{dev} against the percent deviance explained.}

\item{label}{If TRUE, label the curves with variable sequence numbers}
}
\value{
Produces a coefficient profile plot of the coefficient paths for a fitted \code{\link{plasso}} object.
}
\description{
Plot coefficient paths of (Post-) Lasso model.
}
\examples{
# load toeplitz data
data(toeplitz)
# extract target and features from data
y = as.matrix(toeplitz[,1])
X = toeplitz[,-1]
# fit plasso to the data
\donttest{p = plasso::plasso(X,y)}
# plot coefficient paths for Post-Lasso model
\donttest{plot(p, lasso=FALSE, xvar="lambda")}
# plot coefficient paths for Lasso model
\donttest{plot(p, lasso=TRUE, xvar="lambda")}

}
