% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{list_owned_shares}
\alias{list_owned_shares}
\title{List all shares owned by the current user}
\usage{
list_owned_shares(.con)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}
}
\value{
A tibble with one row per share owned by the current user, including columns
for share name, object type, and granted privileges.
}
\description{
Retrieves all database objects that are owned by the current authenticated
user in MotherDuck.
}
\details{
This function executes the \verb{LIST SHARES;} command to return metadata about
all shares created by the current user. The returned tibble includes details
such as the share name, type of object shared, and privileges granted.
}
\examples{
\dontrun{
con <- DBI::dbConnect(duckdb::duckdb(dbdir = tempfile()))
owned_tbl <- list_owned_shares(con)
print(owned_tbl)
}

}
\seealso{
Other db-manage: 
\code{\link{alter_table_schema}()},
\code{\link{copy_tables_to_new_location}()},
\code{\link{create_database}()},
\code{\link{create_if_not_exists_share}()},
\code{\link{create_or_replace_share}()},
\code{\link{create_schema}()},
\code{\link{create_table}()},
\code{\link{delete_and_create_schema}()},
\code{\link{delete_database}()},
\code{\link{delete_schema}()},
\code{\link{delete_table}()},
\code{\link{describe_share}()},
\code{\link{drop_share}()},
\code{\link{list_shared_with_me_shares}()},
\code{\link{upload_database_to_md}()}
}
\concept{db-manage}
