% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArchiveAsyncFSelectFrozen.R
\name{ArchiveAsyncFSelectFrozen}
\alias{ArchiveAsyncFSelectFrozen}
\title{Frozen Rush Data Storage}
\description{
Freezes the Redis data base of an \link{ArchiveAsyncFSelect} to a  \code{data.table::data.table()}.
No further points can be added to the archive but the data can be accessed and analyzed.
Useful when the Redis data base is not permanently available.
Use the callback \link{mlr3fselect.async_freeze_archive} to freeze the archive after the optimization has finished.
}
\section{S3 Methods}{

\itemize{
\item \code{as.data.table(archive)}\cr
\link{ArchiveAsyncFSelectFrozen} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a tabular view of all performed function calls of the Objective.
}
}

\section{Super classes}{
\code{\link[bbotk:Archive]{bbotk::Archive}} -> \code{\link[bbotk:ArchiveAsync]{bbotk::ArchiveAsync}} -> \code{\link[bbotk:ArchiveAsyncFrozen]{bbotk::ArchiveAsyncFrozen}} -> \code{ArchiveAsyncFSelectFrozen}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{benchmark_result}}{(\link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult})\cr
Benchmark result.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ArchiveAsyncFSelectFrozen-new}{\code{ArchiveAsyncFSelectFrozen$new()}}
\item \href{#method-ArchiveAsyncFSelectFrozen-learner}{\code{ArchiveAsyncFSelectFrozen$learner()}}
\item \href{#method-ArchiveAsyncFSelectFrozen-learners}{\code{ArchiveAsyncFSelectFrozen$learners()}}
\item \href{#method-ArchiveAsyncFSelectFrozen-predictions}{\code{ArchiveAsyncFSelectFrozen$predictions()}}
\item \href{#method-ArchiveAsyncFSelectFrozen-resample_result}{\code{ArchiveAsyncFSelectFrozen$resample_result()}}
\item \href{#method-ArchiveAsyncFSelectFrozen-print}{\code{ArchiveAsyncFSelectFrozen$print()}}
\item \href{#method-ArchiveAsyncFSelectFrozen-clone}{\code{ArchiveAsyncFSelectFrozen$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Archive" data-id="format"><a href='../../bbotk/html/Archive.html#method-Archive-format'><code>bbotk::Archive$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Archive" data-id="help"><a href='../../bbotk/html/Archive.html#method-Archive-help'><code>bbotk::Archive$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsync" data-id="best"><a href='../../bbotk/html/ArchiveAsync.html#method-ArchiveAsync-best'><code>bbotk::ArchiveAsync$best()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsync" data-id="nds_selection"><a href='../../bbotk/html/ArchiveAsync.html#method-ArchiveAsync-nds_selection'><code>bbotk::ArchiveAsync$nds_selection()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsyncFrozen" data-id="clear"><a href='../../bbotk/html/ArchiveAsyncFrozen.html#method-ArchiveAsyncFrozen-clear'><code>bbotk::ArchiveAsyncFrozen$clear()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsyncFrozen" data-id="data_with_state"><a href='../../bbotk/html/ArchiveAsyncFrozen.html#method-ArchiveAsyncFrozen-data_with_state'><code>bbotk::ArchiveAsyncFrozen$data_with_state()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsyncFrozen" data-id="pop_point"><a href='../../bbotk/html/ArchiveAsyncFrozen.html#method-ArchiveAsyncFrozen-pop_point'><code>bbotk::ArchiveAsyncFrozen$pop_point()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsyncFrozen" data-id="push_failed_point"><a href='../../bbotk/html/ArchiveAsyncFrozen.html#method-ArchiveAsyncFrozen-push_failed_point'><code>bbotk::ArchiveAsyncFrozen$push_failed_point()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsyncFrozen" data-id="push_points"><a href='../../bbotk/html/ArchiveAsyncFrozen.html#method-ArchiveAsyncFrozen-push_points'><code>bbotk::ArchiveAsyncFrozen$push_points()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsyncFrozen" data-id="push_result"><a href='../../bbotk/html/ArchiveAsyncFrozen.html#method-ArchiveAsyncFrozen-push_result'><code>bbotk::ArchiveAsyncFrozen$push_result()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsyncFrozen" data-id="push_running_point"><a href='../../bbotk/html/ArchiveAsyncFrozen.html#method-ArchiveAsyncFrozen-push_running_point'><code>bbotk::ArchiveAsyncFrozen$push_running_point()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncFSelectFrozen-new"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncFSelectFrozen-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncFSelectFrozen$new(archive)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{archive}}{(\link{ArchiveAsyncFSelect})\cr
The archive to freeze.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncFSelectFrozen-learner"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncFSelectFrozen-learner}{}}}
\subsection{Method \code{learner()}}{
Retrieve \link[mlr3:Learner]{mlr3::Learner} of the i-th evaluation, by position or by unique hash \code{uhash}.
\code{i} and \code{uhash} are mutually exclusive.
Learner does not contain a model. Use \verb{$learners()} to get learners with models.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncFSelectFrozen$learner(i = NULL, uhash = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{(\code{integer(1)})\cr
The iteration value to filter for.}

\item{\code{uhash}}{(\code{logical(1)})\cr
The \code{uhash} value to filter for.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncFSelectFrozen-learners"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncFSelectFrozen-learners}{}}}
\subsection{Method \code{learners()}}{
Retrieve list of trained \link[mlr3:Learner]{mlr3::Learner} objects of the i-th evaluation, by position or by unique hash \code{uhash}.
\code{i} and \code{uhash} are mutually exclusive.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncFSelectFrozen$learners(i = NULL, uhash = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{(\code{integer(1)})\cr
The iteration value to filter for.}

\item{\code{uhash}}{(\code{logical(1)})\cr
The \code{uhash} value to filter for.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncFSelectFrozen-predictions"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncFSelectFrozen-predictions}{}}}
\subsection{Method \code{predictions()}}{
Retrieve list of \link[mlr3:Prediction]{mlr3::Prediction} objects of the i-th evaluation, by position or by unique hash \code{uhash}.
\code{i} and \code{uhash} are mutually exclusive.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncFSelectFrozen$predictions(i = NULL, uhash = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{(\code{integer(1)})\cr
The iteration value to filter for.}

\item{\code{uhash}}{(\code{logical(1)})\cr
The \code{uhash} value to filter for.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncFSelectFrozen-resample_result"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncFSelectFrozen-resample_result}{}}}
\subsection{Method \code{resample_result()}}{
Retrieve \link[mlr3:ResampleResult]{mlr3::ResampleResult} of the i-th evaluation, by position or by unique hash \code{uhash}.
\code{i} and \code{uhash} are mutually exclusive.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncFSelectFrozen$resample_result(i = NULL, uhash = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{(\code{integer(1)})\cr
The iteration value to filter for.}

\item{\code{uhash}}{(\code{logical(1)})\cr
The \code{uhash} value to filter for.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncFSelectFrozen-print"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncFSelectFrozen-print}{}}}
\subsection{Method \code{print()}}{
Printer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncFSelectFrozen$print()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(ignored).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncFSelectFrozen-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncFSelectFrozen-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncFSelectFrozen$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
