#' mdsinfo
#'
#' Compute MDS coordinates for expression data using limma's plotMDS.
#'
#' This function performs multidimensional scaling (MDS) on a DGEList or
#' log-expression matrix using limma's  "plotMDS() " function. It returns the MDS
#' object containing coordinates and eigenvalues without generating a plot.
#'
#' @param matrix A DGEList object.
#' @param top Integer. Number of top most variable genes to include in MDS.
#' @param gene.selection Method for gene selection: one of "pairwise", "common", or "logFC".
#'
#' @return A list object from  "plotMDS() " containing MDS coordinates and eigenvalues.
#'
mdsinfo <- function(matrix, top, gene.selection){
  mds <- limma::plotMDS(x = matrix, top = as.numeric(top), gene.selection = gene.selection, method = "logFC", plot = FALSE)
  # Return the MDS object generated by the plotMDS function
  return(mds)
}
