% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphon_generation.R
\name{scale_graphon}
\alias{scale_graphon}
\title{Scales a graphon to an nxn matrix}
\usage{
scale_graphon(W, n)
}
\arguments{
\item{W}{A graphon given as a symmetric square matrix}

\item{n}{The dimension of the output matrix}
}
\value{
Scaled nxn graphon
}
\description{
Scales a graphon to an nxn matrix suitable for large adjacency matrices
}
\examples{
library(igraph)
gr <- sample_gnp(1000, p=0.2)
adj <- as_adjacency_matrix(gr)
W <- scale_graphon(adj, 100)

}
