% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.points.r
\name{as.points,GRaster-method}
\alias{as.points,GRaster-method}
\alias{as.points}
\alias{as.points,GVector-method}
\title{Convert a GRaster, or lines or polygons GVector to a points vector}
\usage{
\S4method{as.points}{GRaster}(x, values = TRUE)

\S4method{as.points}{GVector}(x)
}
\arguments{
\item{x}{A \code{GRaster}, \code{GVector}.}

\item{values}{Logical: If \code{TRUE} (default), create an attribute table with raster cell values, with one row per point.}
}
\value{
A \code{points} \code{GVector}.
}
\description{
\code{as.points()} converts a \code{GRaster}, or a lines or polygons \code{GVector} to a points \code{GVector}.

For \code{GRasters}, the points have the coordinates of cell centers and are assigned the cells' values. Only non-\code{NA} cells will be converted to points.

For \code{GVectors}, each point will have the attributes of the line or polygon to which it belonged. Points are extracted from each vertex.
}
\examples{
if (grassStarted()) {

# Setup
library(sf)
library(terra)

# Elevation raster, outline of a part of Madagascar, and rivers vector:
madElev <- fastData("madElev")
madCoast0 <- fastData("madCoast0")
madRivers <- fastData("madRivers")

# Convert to GRaster and GVectors:
elev <- fast(madElev)
coast <- fast(madCoast0)
rivers <- fast(madRivers)

# For this example, we will first crop to a small extent.
river <- rivers[1]
elevCrop <- crop(elev, river)
elevPoints <- as.points(elevCrop)
elevPoints

plot(elevCrop)
plot(elevPoints, pch = '.', add = TRUE)

# Extract points from vectors:
coastPoints <- as.points(coast)
riversPoints <- as.points(rivers)

plot(coast)
plot(coastPoints, add = TRUE)

plot(rivers, col = "blue", add = TRUE)
plot(riversPoints, col = "blue", add = TRUE)

}
}
\seealso{
\code{\link[=crds]{crds()}}, \code{\link[=as.lines]{as.lines()}}, \code{\link[=as.polygons]{as.polygons()}}, \code{\link[terra:as.points]{terra::as.points()}}, and modules \code{v.to.points} and \code{r.to.vect} in \strong{GRASS}
}
