% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NonparametricTransformation.R
\name{SolveH}
\alias{SolveH}
\title{Estimate a nonparametric transformation function}
\usage{
SolveH(theta, resData, X, W)
}
\arguments{
\item{theta}{Vector of parameters in the semiparametric transformation model.}

\item{resData}{Data matrix with three columns;  Z = the observed survival time, d1 = the censoring indicator of T
and  d2 =  the censoring indicator of C.}

\item{X}{Data matrix with covariates related to T.}

\item{W}{Data matrix with covariates related to C.}
}
\value{
Returns the estimated transformation function H for a fixed value of parameters theta.
}
\description{
This function estimates the nonparametric transformation  function H when the survival time and censoring time
are dependent given covariates.  The estimating equation of H was derived based on the martingale ideas. More details about
the derivation of a nonparmaetric estimator of H and its estimation algorithm can be found in Deresa and Van Keilegom (2021).
}
\references{
Deresa, N. and Van Keilegom, I. (2021). On semiparametric modelling, estimation and inference for survival data subject to dependent censoring, Biometrika, 108, 965–979.
}
