% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoenc_stacked_e.R
\name{autoenc_stacked_e}
\alias{autoenc_stacked_e}
\title{Stacked Autoencoder - Encode}
\usage{
autoenc_stacked_e(
  input_size,
  encoding_size,
  batch_size = 32,
  num_epochs = 1000,
  learning_rate = 0.001,
  k = 3
)
}
\arguments{
\item{input_size}{input size}

\item{encoding_size}{encoding size}

\item{batch_size}{size for batch learning}

\item{num_epochs}{number of epochs for training}

\item{learning_rate}{learning rate}

\item{k}{Integer. Number of autoencoder layers in the stack.}
}
\value{
A \code{autoenc_stacked_e} object.
}
\description{
Creates a deep learning stacked autoencoder to encode sequences of observations.
The autoencoder layers are based on DAL Toolbox vanilla autoencoder and wrap a PyTorch implementation.
}
\examples{
\dontrun{
X <- matrix(rnorm(1000), nrow = 50, ncol = 20)
ae <- autoenc_stacked_e(input_size = 20, encoding_size = 5, k = 3, num_epochs = 50)
ae <- daltoolbox::fit(ae, X)
Z  <- daltoolbox::transform(ae, X)
}

# See:
# https://github.com/cefet-rj-dal/daltoolbox/blob/main/autoencoder/autoenc_stacked_e.md
}
\references{
Vincent, P., Larochelle, H., Lajoie, I., Bengio, Y., & Manzagol, P.-A. (2010).
Stacked Denoising Autoencoders: Learning Useful Representations in a Deep Network with a Local Denoising Criterion.
}
