% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_smoothing_freq.R
\name{smoothing_freq}
\alias{smoothing_freq}
\title{Smoothing by equal frequency}
\usage{
smoothing_freq(n)
}
\arguments{
\item{n}{number of bins}
}
\value{
returns an object of class \code{smoothing_freq}
}
\description{
Discretize a numeric vector into \code{n} bins with approximately equal frequency (quantile cuts),
and replace each value by the mean of its bin.
}
\examples{
data(iris)
obj <- smoothing_freq(n = 2)
obj <- fit(obj, iris$Sepal.Length)
sl.bi <- transform(obj, iris$Sepal.Length)
table(sl.bi)
obj$interval

entro <- evaluate(obj, as.factor(names(sl.bi)), iris$Species)
entro$entropy
}
\references{
Han, J., Kamber, M., Pei, J. (2011). Data Mining: Concepts and Techniques. (Discretization)
}
