% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/li_diameter_raster.R
\name{li_diameter_raster}
\alias{li_diameter_raster}
\title{Calculate a raster of crown diameter for tree height for AMS3D}
\usage{
li_diameter_raster(
  point_cloud,
  crown_diameter_constant = 0,
  limits = c(0, 1),
  ground_height = NULL,
  smoothing_radius = 5,
  ...
)
}
\arguments{
\item{point_cloud}{the input point cloud, either as LAS or as data.frame.}

\item{crown_diameter_constant}{a fixed value for crown_diameter_constant, which
reduces the crown diameters by the given value before calculating the ratio
of crown diameter to tree height}

\item{limits}{a numeric vector with minimum and maximum values for
the ratio, at which every tree's ratio will be capped}

\item{ground_height}{(optional) either
\itemize{
\item NULL, indicating that the point cloud is normalized, or
\item a \link[terra:SpatRaster-class]{SpatRaster} digital terrain model, or
\item a list of arguments to the
\link[lidR:rasterize]{lidR rasterize_terrain()} function to normalize
the point cloud.
}}

\item{smoothing_radius}{The radius of the filter used for smoothing the
diameter-to-height ratio from individual trees.}

\item{...}{further parameters will be passed to the function \code{\link[lidR:its_li2012]{lidR::li2012()}}}
}
\value{
terra SpatRaster
}
\description{
The function calculates a raster with values for
crown_diameter_to_tree_height as input for the AMS3D algorithm. It segments
the tree crowns with the Li2012 algorithm, calculates a ratio of crown
diameter to tree height for each tree, and converts this into a raster.
}
\section{Details}{


The output raster can serve as input for the parameter
"crown_diameter_to_tree_height" for the function segment_tree_crowns.
It averages the ratio of crown diameter to tree height for a given radius,
for trees that were detected with the Li2012 tree segmentation algorithm.
}

