% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_region_plot.R
\name{render_region_plot}
\alias{render_region_plot}
\title{Render a regional raster plot with optional custom boundaries}
\usage{
render_region_plot(
  infile,
  outfile = NULL,
  fileExtension = ".png",
  visualizeVariables,
  visualizeDataMax,
  lon_bounds,
  lat_bounds,
  lon_loc_vec,
  lat_loc_vec,
  name_loc_vec,
  division,
  selectedRegion,
  region_data,
  timestep,
  num_tick,
  num_rmin,
  num_rmax,
  location,
  text1,
  text2,
  text3,
  PAL,
  palettes,
  num_brk,
  reverse,
  textsize,
  bordercolor,
  plot_grid,
  grid_col,
  image_def,
  ihsf,
  nc = NULL
)
}
\arguments{
\item{infile}{Character path to the NetCDF input file.}

\item{outfile}{Optional path for the output image file. If \code{NULL}, a temp file is used.}

\item{fileExtension}{Output file extension, one of \code{".png"}, \code{".jpg"}, \code{".pdf"}.}

\item{visualizeVariables}{List with at least \code{$vn} (variable name) and \code{$date.time}.}

\item{visualizeDataMax}{Numeric; used for colorbar tick calculation.}

\item{lon_bounds, lat_bounds}{Numeric vectors of visible longitude/latitude bounds (unused here but part of API).}

\item{lon_loc_vec, lat_loc_vec, name_loc_vec}{Optional location markers (lon/lat + labels).}

\item{division}{Character name of the attribute/level used to select the region (e.g. \code{"COUNTRY"} or a shapefile field).}

\item{selectedRegion}{Character code/value of the selected region (e.g. ISO3).}

\item{region_data}{Spatial or sf object with user-provided regions (when \code{division != "COUNTRY"}).}

\item{timestep}{Selected timestep (should match an entry of \code{visualizeVariables$date.time}).}

\item{num_tick, num_rmin, num_rmax}{Numeric settings for legend ticks and z range.}

\item{location}{Logical; draw location markers if \code{TRUE}.}

\item{text1, text2, text3}{Character strings for title, footer, and legend label.}

\item{PAL, palettes, num_brk, reverse}{Color palette settings passed to \code{getColors()}.}

\item{textsize}{Numeric base text size used in plotting.}

\item{bordercolor}{Color for region borders and markers.}

\item{plot_grid, grid_col}{Currently unused plotting options (kept for API compatibility).}

\item{image_def, ihsf}{Image sizing settings from the Toolbox.}

\item{nc}{Optional opened NetCDF handle; if provided, \code{infile <- nc$filename}.}
}
\value{
A named list with \code{src} (file path), \code{contentType}, \code{width}, \code{height}.
}
\description{
Produces a map image for a selected region by cropping/masking a NetCDF raster,
handling longitude wrap (0–360 -> -180–180), CRS alignment, and setting sane
plot limits/aspect. Designed for use in the CM SAF R Toolbox.
}
\details{
The function:
\enumerate{
\item Loads the raster brick for the requested variable.
\item Normalizes longitudes to -180 to 180 if input is 0–360 (via \code{raster::rotate}).
\item Validates/aligns the region geometry (sf -> Spatial, EPSG:4326, transform to raster CRS).
\item Crops/masks the raster by the region and draws the image with geographic aspect.
}
The package \pkg{lwgeom} is used \emph{optionally} (via \code{requireNamespace}) to fix invalid geometries;
a \code{st_buffer(., 0)} fallback is applied if \pkg{lwgeom} is not available.
}
