% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnt_path.R
\name{cnt_path}
\alias{cnt_path}
\title{Find the shortest path between start and end points within a polygon}
\usage{
cnt_path(skeleton, start_point, end_point)
}
\arguments{
\item{skeleton}{an output from \code{\link[=cnt_skeleton]{cnt_skeleton()}} function}

\item{start_point}{one or more starting points. It should be of the same
class as the \code{skeleton} parameter}

\item{end_point}{one ending point of the same class as \code{skeleton} and
\code{start_point} parameters.}
}
\value{
a list of \code{sf}, \code{sfc}, \code{SpatVector}
or \code{geos_geometry} class objects of a \code{LINESTRING} geometry
}
\description{
Find the shortest path between start and end points within a polygon
}
\details{
The following function uses the \code{\link[sfnetworks:st_network_paths]{sfnetworks::st_network_paths()}} approach to
connect \code{start_point} with \code{end_point} by using the
\code{skeleton} of a closed polygon as potential routes.

It is important to note that multiple starting points are permissible,
but there can only be \strong{one ending point}. Should there be two or more
ending points, the algorithm will return an error.

Neither starting nor ending points are required to be located
on the edges of a polygon (i.e., snapped to the boundary);
they can be positioned wherever possible inside the polygon.

The algorithm identifies the closest nodes of the polygon's skeleton
to the starting and ending points and then connects them
using the shortest path possible along the skeleton.
Therefore, if more precise placement of start and end
points is necessary, consider executing the \code{\link[=cnt_skeleton]{cnt_skeleton()}}
function with the \code{keep = 1} option. In doing so, the resulting
skeleton may be more detailed, increasing the likelihood that the starting
and ending points are already situated on the skeleton paths.
}
\examples{
library(sf)
library(geos)
# Load Polygon and points data
polygon <-
  sf::st_read(
    system.file("extdata/example.gpkg", package = "centerline"),
    layer = "polygon",
    quiet = TRUE
  ) |>
  geos::as_geos_geometry()

points <-
  sf::st_read(
    system.file("extdata/example.gpkg", package = "centerline"),
    layer = "polygon_points",
    quiet = TRUE
  ) |>
  geos::as_geos_geometry()

# Find polygon's skeleton
pol_skeleton <- cnt_skeleton(polygon)

# Connect points
pol_path <-
  cnt_path(
    skeleton = pol_skeleton,
    start_point = points[2],
    end_point = points[1]
  )

# Plot
plot(polygon)
plot(pol_skeleton, col = "blue", add = TRUE)
plot(points[1:2], col = "red", add = TRUE)
plot(pol_path, lwd = 3, add = TRUE)
}
