% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_stats_prop_test.R
\name{ard_stats_prop_test}
\alias{ard_stats_prop_test}
\title{ARD 2-sample proportion test}
\usage{
ard_stats_prop_test(data, by, variables, conf.level = 0.95, ...)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column name to compare by}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column names to be compared. Must be a binary column coded as \code{TRUE}/\code{FALSE}
or \code{1}/\code{0}. Independent tests will be computed for each variable.}

\item{conf.level}{(scalar \code{numeric})\cr
confidence level for confidence interval. Default is \code{0.95}.}

\item{...}{arguments passed to \code{prop.test(...)}}
}
\value{
ARD data frame
}
\description{
Analysis results data for a 2-sample test or proportions using \code{\link[stats:prop.test]{stats::prop.test()}}.
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = "broom"))) withAutoprint(\{ # examplesIf}
mtcars |>
  ard_stats_prop_test(by = vs, variables = am)
\dontshow{\}) # examplesIf}
}
