% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc_dim.R
\name{bc_dim}
\alias{bc_dim}
\title{Predict Broadcasted Dimensions}
\usage{
bc_dim(x, y)
}
\arguments{
\item{x, y}{an atomic or recursive array.}
}
\value{
Returns an integer vector giving the broadcasted dimension sizes of the result,
or the length of the result if its dimensions will be \code{NULL}. \cr \cr
}
\description{
\code{bc_dim(x, y)} gives the dimensions an array would have,
as the result of an broadcasted binary element-wise operation between 2 arrays
\code{x} and \code{y}.
}
\examples{
x.dim <- c(4:2)
x.len <- prod(x.dim)
x.data <- sample(c(TRUE, FALSE, NA), x.len, TRUE)
x <- array(x.data, x.dim)
y <- array(1:50, c(4,1,1))

dim(bc.b(x, y, "&")) == bc_dim(x, y)
dim(bc.b(x, y, "|")) == bc_dim(x, y)

}
