% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pneumonia.R
\docType{data}
\name{pneumonia}
\alias{pneumonia}
\title{pneumonia Bayesian Network}
\format{
A discrete Bayesian network  to predict causative pathogens for childhood pneumonia. Probabilities were given within the referenced paper. The vertices are:
\describe{
\item{Age Group}{Age group of study participant. In the model, we define each group as follow: Infant (<=2yo), PreSchool (2-5yo), School (5-18yo);}
\item{Ethnicity}{Australian Indigenous status of participant, including Aboriginal, Pacific Islander, and Maori (Indigenous, NonIndigenous);}
\item{SmokerInHousehold}{(Yes, No);}
\item{Prematurity}{Born <37 weeks gestation (Yes, No);}
\item{ChildcareDays}{Childcare or school attendance, day/s per week (Five or more, Two to four, One or less);}
\item{ImpairedImmunity}{Primary immunodeficiencies, immunocompromising, or use of immunosuppressive drug (Reported, Unknown);}
\item{ChronicRespiratoryDisease}{(Reported, Unknown);}
\item{PreviousSignificantInfection}{Previous episode of confirmed significant infection e.g. bacteraemia, meningitis, osteomyelitis, urinary infection, and etc (Reported, Unknown);}
\item{InfluenzaSeason}{Participant was enrolled (present to hospital) during the influenza season in Australia, which is defined as June to September (No, Yes);}
\item{PneumococcalVaccine}{The number of pneumococcal vaccine received, according to Australian Childhood Immunisation Register (ACIR); a child is defined as fully vaccinated if three or more doses were recorded, and under vaccinated if less than three doses (UnderVax, FullyVax);}
\item{InfluenzaVaccine}{Influenza vaccine received within one year prior to this presentation/ enrolment, according to ACIR (No, Yes);}
\item{LevelOfExposure}{This refers to the child’s exposure to pathogens with more transient and transmissible characteristics (High, Low);}
\item{SusceptibilityToColonisation}{This summarises the level of a child’s susceptibility to nasopharyngeal colonisation by typical bacterial pathogens that can be responsible for the presenting case of pneumonia (High, Low);}
\item{SusceptibilityToProgression}{This describes the extent of the child to progress to more severe manifestation of pneumonia if infected (High, Low);}
\item{RSVInNasopharynx}{Any detection of RSV from nasopharyngeal swab or aspiration via either the prospective study or routine clinical investigation (Positive, Negative);}
\item{HMPVInNasopharynx}{Any detection of HMPV from nasopharyngeal swab or aspiration via either the prospective study or routine clinical investigation (Positive, Negative);}
\item{InfluenzaInNasopharynx}{Any detection of influenza from nasopharyngeal swab or aspiration via either the prospective study or routine clinical investigation (Positive, Negative);}
\item{ParainfluenzaInNasopharynx}{Any detection of parainfluenza from nasopharyngeal swab or aspiration via either the prospective study or routine clinical investigation (Positive, Negative);}
\item{MycoplasmaInNasopharynx}{Any detection of mycoplasma from nasopharyngeal swab or aspiration via either the prospective study or routine clinical investigation (Positive, Negative);}
\item{TypicalBacteriaInNasopharynx}{Any detection of typical bacteria is present in nasopharynx via either the prospective study or routine clinical investigation (Yes, No);}
\item{ViralNasopharyngealInfection}{Replication of viral-like pathogens is occuring in the nasopharyngeal tissues (Present, Absent);}
\item{ThroatInfection}{Replication of viral-like pathogens is occuring in the laryngeal tissues (Present, Absent);}
\item{ViralLikePneumonia}{Replication of viral-like pathogens is occuring in the terminal air spaces of the respiratory tract (Present, Absent);}
\item{TypicalBacterialPneumonia}{Typical bacteria is invading the terminal air spaces of the respiratory tract (Present, Absent);}
\item{CausativePathogenForPneumonia}{The cause of presenting pneumonia (TypicalBac, ViralLike, NoPneumonia);}
\item{UpperAirwayInvolvment}{Involvement of other site/s of respiratory tract concurrent with the presenting pneumonia episode (NP, Throat, NPAndThroat, No);}
\item{SubjectGroup}{X-ray confirmed pneumonia (Case, Control);}
\item{DiagnosisBacterialPneumonia}{In this study, baterial pneumonia is clinically diagnosed based on clinical diagnosis of pleural effusion or positive blood culture result (Yes, No);}
\item{Cough}{(Recorded, Unknown);}
\item{Headache}{(Recorded, Unknown);}
\item{Rhinorrhoea}{(Recorded, Unknown);}
\item{SoreThroat}{(Recorded, Unknown);}
\item{Earache}{(Recorded, Unknown);}
\item{Fever}{(Recorded, Unknown);}
\item{Irritability}{(Recorded, Unknown);}
\item{OtherPain}{(Recorded, Unknown);}
\item{HighestTemperature}{(Above 39, Between 38 and 39, Below 38);}
\item{ChillSweat}{(Recorded, Unknown);}
\item{Vomiting}{(Recorded, Unknown);}
\item{Diarrhoea}{(Recorded, Unknown);}
\item{ReducedOralIntake}{(Recorded, Unknown);}
\item{EnergyLoss}{(Recorded, Unknown);}
\item{Wheezing}{(Recorded, Unknown);}
\item{Crackles}{(Recorded, Unknown);}
\item{DurationOfSymptomsOnset}{(More than one week, Three to seven days, One or two days);}
\item{PleuralEffusion}{The build-up of excess fluid between the layers of the pleura outside the lungs. The true status of pleural effusion can not be directly observed, therefore is latent. Clinical diagnosis of pleural effusion is used as a surrogate for the true status (thus classified as signs and is observable) (Yes, No);}
\item{AbdominalPain}{(Recorded, Unknown);}
\item{ChestPain}{(Recorded, Unknown);}
\item{BreathingDifficulty}{(Recorded, Unknown);}
\item{RespiratoryRate}{(Above 50, Between 30 and 50, Below 30);}
\item{Rash}{(Recorded, Unknown);}
\item{CurrentPhenotype}{This was introduced as a summary node of patient presentation phenotypes based on signs and symptoms relevant to pneumonia (Type1, Type2);}
\item{BloodCultureResult}{Detection of any (non-contaminant) bacteria from blood culture via routine clinical investigation (Positive, Negative, NotDone);}
\item{PleuralFluidResult}{Detection of any bacteria from pleural fluid via either PCR or culture (Positive, Negative, NotDone);}
\item{CReactiveProtein}{(Above 70, Between 30 and 70, Below 30);}
\item{WhiteCellCount}{(Above 18, Between 10 and 18, Below 10);}
\item{NeutrophilProportion}{(Above 80, Between 50 and 80, Below 50);}
\item{OxygenSaturation}{(Below 92, Between 92 and 95, Above 95);}
\item{HospitalTransfer}{Transferred from another hospital/facility (Yes, No);}
\item{AntibioticExposure}{Any antibiotic use in the 7 days or 24 hours prior to this presentation/admission (LastDay, LastWeek, No);}
\item{BloodCulturePerformed}{(Yes, No);}
\item{O2Type}{If the child has been put on supplementary oxygen when measuring oxygen saturation (SuppO2, RoomAir);}
}
}
\value{
An object of class \code{bn.fit}. Refer to the documentation of \code{bnlearn} for details.
}
\description{
Predicting the causative pathogen among children with pneumonia using a causal Bayesian network.
}
\references{
Wu, Y., Mascaro, S., Bhuiyan, M., Fathima, P., Mace, A. O., Nicol, M. P., ... & Blyth, C. C. (2023). Predicting the causative pathogen among children with pneumonia using a causal Bayesian network. PLoS Computational Biology, 19(3), e1010967.
}
