% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallbackBatch.R
\name{CallbackBatch}
\alias{CallbackBatch}
\title{Create Batch Optimization Callback}
\description{
Specialized \link[mlr3misc:Callback]{mlr3misc::Callback} for batch optimization.
Callbacks allow to customize the behavior of processes in bbotk.
The \code{\link[=callback_batch]{callback_batch()}} function creates a \link{CallbackBatch}.
Predefined callbacks are stored in the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_callbacks} and can be retrieved with \code{\link[=clbk]{clbk()}}.
For more information on optimization callbacks see \code{\link[=callback_batch]{callback_batch()}}.
}
\examples{
# write archive to disk
callback_batch("bbotk.backup",
  on_optimization_end = function(callback, context) {
    saveRDS(context$instance$archive, "archive.rds")
  }
)
}
\seealso{
\code{\link[=callback_batch]{callback_batch()}}
}
\section{Super class}{
\code{\link[mlr3misc:Callback]{mlr3misc::Callback}} -> \code{CallbackBatch}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{on_optimization_begin}}{(\verb{function()})\cr
Stage called at the beginning of the optimization.
Called in \code{Optimizer$optimize()}.}

\item{\code{on_optimizer_before_eval}}{(\verb{function()})\cr
Stage called after the optimizer proposes points.
Called in \code{OptimInstance$eval_batch()}.}

\item{\code{on_optimizer_after_eval}}{(\verb{function()})\cr
Stage called after points are evaluated.
Called in \code{OptimInstance$eval_batch()}.}

\item{\code{on_result_begin}}{(\verb{function()})\cr
Stage called before the results are written.
Called in \code{OptimInstance$assign_result()}.}

\item{\code{on_result_end}}{(\verb{function()})\cr
Stage called after the results are written.
Called in \code{OptimInstance$assign_result()}.}

\item{\code{on_optimization_end}}{(\verb{function()})\cr
Stage called at the end of the optimization.
Called in \code{Optimizer$optimize()}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CallbackBatch-clone}{\code{CallbackBatch$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3misc" data-topic="Callback" data-id="call"><a href='../../mlr3misc/html/Callback.html#method-Callback-call'><code>mlr3misc::Callback$call()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3misc" data-topic="Callback" data-id="format"><a href='../../mlr3misc/html/Callback.html#method-Callback-format'><code>mlr3misc::Callback$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3misc" data-topic="Callback" data-id="help"><a href='../../mlr3misc/html/Callback.html#method-Callback-help'><code>mlr3misc::Callback$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3misc" data-topic="Callback" data-id="initialize"><a href='../../mlr3misc/html/Callback.html#method-Callback-initialize'><code>mlr3misc::Callback$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3misc" data-topic="Callback" data-id="print"><a href='../../mlr3misc/html/Callback.html#method-Callback-print'><code>mlr3misc::Callback$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CallbackBatch-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CallbackBatch-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CallbackBatch$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
