% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tail_to_signal_ratio.R
\name{tail_to_signal_ratio}
\alias{tail_to_signal_ratio}
\title{Measure reverberations as tail-to-signal ratio}
\usage{
tail_to_signal_ratio(
  X,
  mar,
  cores = getOption("mc.cores", 1),
  pb = getOption("pb", TRUE),
  tsr.formula = 1,
  bp = "freq.range",
  hop.size = getOption("hop.size", 1),
  wl = getOption("wl", NULL),
  ovlp = getOption("ovlp", 0),
  path = getOption("sound.files.path", ".")
)
}
\arguments{
\item{X}{Object of class 'data.frame', 'selection_table' or 'extended_selection_table' (the last 2 classes are created by the function \code{\link[warbleR]{selection_table}} from the warbleR package) with the test sound files' annotations . Must contain the following columns: 1) "sound.files": name of the .wav files, 2) "selec": unique selection identifier (within a sound file), 3) "start": start time and 4) "end": end time of selections, 5)  "bottom.freq": low frequency for bandpass and 6) "top.freq": high frequency for bandpass.}

\item{mar}{numeric vector of length 1. Specifies the margins adjacent to
end of the sound over which to measure tail power.}

\item{cores}{Numeric vector of length 1. Controls whether parallel computing is applied by specifying the number of cores to be used. Default is 1 (i.e. no parallel computing). Can be set globally for the current R session via the "mc.cores" option (see \code{\link[base]{options}}).}

\item{pb}{Logical argument to control if progress bar is shown. Default is \code{TRUE}.  Can be set globally for the current R session via the "pb" option (see \code{\link[base]{options}}).}

\item{tsr.formula}{Integer vector of length 1. Determine the formula to be used to calculate the tail-to-signal ratio (S = signal, T = tail, N = background noise):
\itemize{
\item \code{1}: log10 of the ratio of T amplitude envelope quadratic mean to S amplitude envelope quadratic mean
 (\code{log10(rms(env(T))/rms(env(S)))}) as described by Dabelsteen et al. (1993).
\item \code{2}: ratio of T amplitude envelope quadratic mean to N amplitude envelope quadratic mean (\code{log10(rms(env(T))/rms(env(N)))}). N is measure in the margin right before the sound. So tsr.formula 2 actually measures tail-to-noise ratio.
}}

\item{bp}{Numeric vector of length 2 giving the lower and upper limits of a frequency bandpass filter (in kHz). Alternatively, when set to 'freq.range' (default), the function will use the 'bottom.freq' and 'top.freq' for each sound as the bandpass range.}

\item{hop.size}{A numeric vector of length 1 specifying the time window duration (in ms). Default is 1 ms, which is equivalent to ~45 wl for a 44.1 kHz sampling rate. Ignored if 'wl' is supplied. Can be set globally for the current R session via the "hop.size" option (see \code{\link[base]{options}}). Note that this might be internally adjusted if the number of samples in the tail is lower than the hop.size.}

\item{wl}{A numeric vector of length 1 specifying the window length of the spectrogram, default
is NULL. Ignored if \code{bp = NULL}. If supplied, 'hop.size' is ignored.
Note that lower values will increase time resolution, which is more important for amplitude calculations.}

\item{ovlp}{Numeric vector of length 1 specifying the percentage of overlap between two
consecutive windows, as in \code{\link[seewave]{spectro}}. Default is 0. Only used for bandpass filtering. Can be set globally for the current R session via the "ovlp" option (see \code{\link[base]{options}}).}

\item{path}{Character string containing the directory path where the sound files are found. Only needed when 'X' is not an extended selection table. If not supplied the current working directory is used. Can be set globally for the current R session via the "sound.files.path" option (see \code{\link[base]{options}}).}
}
\value{
Object 'X' with an additional column, 'tail.to.signal.ratio',
with the tail-to-signal ratio values (in dB).
}
\description{
\code{tail_to_signal_ratio} measures reverberations as tail-to-signal ratio of sounds referenced in an extended selection table.
}
\details{
Tail-to-signal ratio (TSR) measures the ratio of power in the tail of reverberations to that in the test sound. A general margin in which reverberation tail will be measured must be specified. The function will measure TSR within the supplied frequency range (e.g. bandpass) of the reference sound ('bottom.freq' and 'top.freq' columns in 'X'). Two methods for computing reverberations are provided (see 'tsr.formula' argument). Note that 'tsr.formula' 2 is not equivalent to the original description of TSR in Dabelsteen et al. (1993) and  is better referred to as tail-to-noise ratio. Tail-to-signal ratio values are typically negative as signals tend to have higher power than that in the reverberating tail. TSR can be ~0 when both tail and signal have very low amplitude.
}
\examples{
{
  # load example data

  data("test_sounds_est")

  # set global options
  options(pb = FALSE)

  # using margin for noise of 0.01
  tsr <- tail_to_signal_ratio(X = test_sounds_est, mar = 0.01)

  # use tsr.formula 2 which is equivalent to tail-to-noise ratio
  tsr <- tail_to_signal_ratio(X = test_sounds_est, mar = 0.01, tsr.formula = 2)
}

}
\references{
Araya-Salas, M., Grabarczyk, E. E., Quiroz-Oliva, M., Garcia-Rodriguez, A., & Rico-Guevara, A. (2025). Quantifying degradation in animal acoustic signals with the R package baRulho. Methods in Ecology and Evolution, 00, 1-12. https://doi.org/10.1111/2041-210X.14481
Darden, SK, Pedersen SB, Larsen ON, & Dabelsteen T. (2008). Sound transmission at ground level in a short-grass prairie habitat and its implications for long-range communication in the swift fox *Vulpes velox*. The Journal of the Acoustical Society of America, 124(2), 758-766.
Mathevon, N., Dabelsteen, T., & Blumenrath, S. H. (2005). Are high perches in the blackcap Sylvia atricapilla song or listening posts? A sound transmission study. The Journal of the Acoustical Society of America, 117(1), 442-449.
}
\seealso{
\code{\link{excess_attenuation}}

Other quantify degradation: 
\code{\link{blur_ratio}()},
\code{\link{detection_distance}()},
\code{\link{envelope_correlation}()},
\code{\link{plot_blur_ratio}()},
\code{\link{plot_degradation}()},
\code{\link{set_reference_sounds}()},
\code{\link{signal_to_noise_ratio}()},
\code{\link{spcc}()},
\code{\link{spectrum_blur_ratio}()},
\code{\link{spectrum_correlation}()}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
\concept{quantify degradation}
