% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findOverlap.R
\name{findOverlap}
\alias{findOverlap}
\alias{imageCorr}
\title{Find image overlaps}
\usage{
findOverlap(
  img_paths = NULL,
  imgs = NULL,
  overlap_px = NULL,
  max_shift_px = NULL,
  perc_better_per_px = 0.01,
  corr_formula = "1-rel_eucl_diff_colors",
  stitch_direction = "left_to_right",
  return_all_results = FALSE,
  show_messages = TRUE
)

imageCorr(
  img_paths = NULL,
  imgs = NULL,
  corr_formula = "1-rel_eucl_diff_colors"
)
}
\arguments{
\item{img_paths}{(Optional, default = NULL) Character vector specifying all
of the individual image paths of interest. This is only used if
\code{imgs} is set to NULL. For \code{ImageCorr()} it must have length 2.}

\item{imgs}{List of images (e.g., provided by the RootDetector). Each image
can be a PNG, i.e., an array with 3 dimensions (3 layers each containing a
2-dim. numeric matrix with values between 0 and 1), or a 2-dim. matrix.
For \code{ImageCorr()} it must have length 2.}

\item{overlap_px}{Numeric vector (default NULL) specifying the (likely)
widths of the overlaps between two consecutive images. The vector must have
one element less than there are images and must not contain any negative
values. If NULL, it is set to 1's.}

\item{max_shift_px}{Numeric vector (default NULL) specifying the maximal
deviation in pixels from the \code{overlap_px}, i.e., all possible
overlaps in that range from the likely overlap are compared and the best
is chosen if it is better than the \code{overlap_px} (see also
\code{perc_better_per_px}). If \code{overlap_px} is already exact, then set
\code{max_shift_px} to zero(s). If at NULL, it is set to 5 percent of the
image widths.}

\item{perc_better_per_px}{Numeric value (percentage, default 0.01, i.e., 1
percent) specifying how much better the correlation of an overlap must be
than the \code{overlap_px} per pixel difference, to be selected instead.
If set to 0, the overall best correlation determines the overlap.
Example: If set to 0.01 = 1 percent, an overlap being 4 pixels away from
the specified \code{overlap_px} must have a correlation better/higher than
1.01^4 times the correlation value of \code{overlap_px} to be chosen as the
better overlap.}

\item{corr_formula}{Character value specifying the formula to be used
(by default 1) for calculating how good an overlap of two images is, i.e.,
how similar the two overlapping images are. Available are the following
formulas: \cr
\itemize{
\item "frac_matches_rgb_intensities": Fraction of matching intensities over all
three color channels. Only suitable for images with few unique colors.
Ranges from 0 (no matches) to 1 (full match).\cr
\item "frac_matches_colors": Fraction of matching colors in the images. Only
suitable for images with few unique colors.
Ranges from 0 (no matches) to 1 (full match).\cr
\item "weighted_matches_b_w": Counts the matches of black and white pixels and
weighs them anti-proportional to the black and white pixel frequencies.
Both black and white make up half of the correlation score.
Only suitable for images with mostly pure black and white pixels.
Ranges from 0 (no matches) to 1 (full match).\cr
\item "weighted_matches_colors": Counts the matches per unique color and weighs
them anti-proportional to the frequencies of the colors.
Each unique color makes up the same fraction of the correlation score.
Only suitable for images with few unique colors.
Ranges from 0 (no matches) to 1 (full match).\cr
\item "1-rel_sqrd_diff_rgb_intensities": One minus the relative squared
difference of intensities across all color channels.
Ranges from 0 (no matches) to 1 (full match).\cr
\item "1-rel_abs_diff_rgb_intensities": One minus the relative absolute
difference of intensities across all color channels.
Ranges from 0 (no matches) to 1 (full match).\cr
\item "1-rel_eucl_diff_colors" (default): One minus the relative Euclidean
differences of colors.
Ranges from 0 (no matches) to 1 (full match).
}}

\item{stitch_direction}{Character specifying in which order the images
should be stitched. Available are: 'left_to_right' (default),
'right_to_left', 'top_to_bottom', and 'bottom_to_top'.}

\item{return_all_results}{Specify if all checked overlaps with their
respective correlation score should be returned (default FALSE).}

\item{show_messages}{Specify if messages should be depicted (default TRUE).}
}
\value{
\code{findOverlap} Numeric vector containing the best (according
to the parameters) widths of the overlaps between the consecutive images.
The vector has one element less than there are images. Its attribute "corr"
holds the respective correlation value.
If \code{return_all_results} is set to true, a list containing a
3-column-matrix for each element in the above mentioned vector, is returned,
i.e, for each transition of two consecutive images we have the first
column containing the overlaps in pixel, the second column holding the
respective correlation values, and the third holding the threshold
correlation values accoriding to \code{overlap_px} and
\code{perc_better_per_px}.

\code{imageCorr} Numeric value (correlations score).
}
\description{
\code{findOverlap} - This function searches for the best overlap between
each pair of consecutive images (see parameters for more details on the
method).

\code{imageCorr} - This function computes the similarity/correlation of two
images.
}
\examples{
# Example of finding the best overlap of two matrices.
overlap <- findOverlap(imgs = list(matrix(c(1,0,0,0,
                                            0,1,0,0,
                                            0,0,1,1), ncol = 4, nrow = 3,
                                      byrow = TRUE),
                                   matrix(c(0,0,0,0,
                                            1,0,0,1,
                                            0,1,1,0), ncol = 4, nrow = 3,
                                      byrow = TRUE)),
                       overlap_px = 1, max_shift_px = 2,
                       return_all_results = TRUE)
# Example of computing the similarity of two images/matrices.
imageCorr(imgs = list(matrix(c(1,0,0,1,
                               1,1,1,1,
                               0,1,1,1), ncol = 4, nrow = 3, byrow = TRUE),
                      matrix(c(1,0,0,0,
                               1,1,1,1,
                               0,1,1,1), ncol = 4, nrow = 3, byrow = TRUE)),
                      corr_formula = "weighted_matches_colors")
}
