% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbGetInfo.R
\name{dbGetInfo,PrestoDriver-method}
\alias{dbGetInfo,PrestoDriver-method}
\alias{dbGetInfo,PrestoConnection-method}
\alias{dbGetInfo,PrestoResult-method}
\title{Metadata about database objects}
\usage{
\S4method{dbGetInfo}{PrestoDriver}(dbObj)

\S4method{dbGetInfo}{PrestoConnection}(dbObj)

\S4method{dbGetInfo}{PrestoResult}(dbObj)
}
\arguments{
\item{dbObj}{A \linkS4class{PrestoDriver},
\linkS4class{PrestoConnection}
or \linkS4class{PrestoResult} object}
}
\value{
\linkS4class{PrestoResult} A \code{\link[=list]{list()}} with elements
\describe{
\item{statement}{The SQL sent to the database}
\item{row.count}{Number of rows fetched so far}
\item{has.completed}{Whether all data has been fetched}
\item{stats}{Current stats on the query}
}
}
\description{
Metadata about database objects

For the \linkS4class{PrestoResult} object, the implementation
returns the additional \code{stats} field which can be used to
implement things like progress bars. See the examples section.
}
\examples{
\dontrun{
conn <- dbConnect(Presto(), "localhost", 7777, "onur", "datascience")
result <- dbSendQuery(conn, "SELECT * FROM jonchang_iris")
iris <- data.frame()
progress.bar <- NULL
while (!dbHasCompleted(result)) {
  chunk <- dbFetch(result)
  if (!NROW(iris)) {
    iris <- chunk
  } else if (NROW(chunk)) {
    iris <- rbind(iris, chunk)
  }
  stats <- dbGetInfo(result)[["stats"]]
  if (is.null(progress.bar)) {
    progress.bar <- txtProgressBar(0, stats[["totalSplits"]], style = 3)
  } else {
    setTxtProgressBar(progress.bar, stats[["completedSplits"]])
  }
}
close(progress.bar)
}
}
