% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sampling.R
\name{createSampleSettings}
\alias{createSampleSettings}
\title{Create the settings for defining how the trainData from \code{splitData} are sampled using
default sample functions.}
\usage{
createSampleSettings(
  type = "none",
  numberOutcomestoNonOutcomes = 1,
  sampleSeed = sample(10000, 1)
)
}
\arguments{
\item{type}{(character) Choice of:  \itemize{
\item 'none' No sampling is applied - this is the default
\item 'underSample' Undersample the non-outcome class to make the data more balanced
\item 'overSample' Oversample the outcome class by adding in each outcome multiple times
}}

\item{numberOutcomestoNonOutcomes}{(numeric) A numeric specifying the required number of outcomes per non-outcomes}

\item{sampleSeed}{(numeric) A seed to use when splitting the data for reproducibility (if not set a random number will be generated)}
}
\value{
An object of class \code{sampleSettings}
}
\description{
Create the settings for defining how the trainData from \code{splitData} are sampled using
default sample functions.
}
\details{
Returns an object of class \code{sampleSettings} that specifies the sampling function that will be called and the settings
}
\examples{
\dontshow{if (rlang::is_installed("Eunomia")) withAutoprint(\{ # examplesIf}
\donttest{
# sample even rate of outcomes to non-outcomes
sampleSetting <- createSampleSettings(
  type = "underSample",
  numberOutcomestoNonOutcomes = 1,
  sampleSeed = 42
)
}
\dontshow{\}) # examplesIf}
}
