% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{simuMSARX}
\alias{simuMSARX}
\title{Simulate Markov-switching ARX process}
\usage{
simuMSARX(mdl_h0, burnin = 100)
}
\arguments{
\item{mdl_h0}{List containing the following DGP parameters
\itemize{
  \item n: Length of series.
  \item k: Number of regimes.
  \item mu: A (\code{k x 1}) vector with mean of process in each regime.
  \item sigma: A (\code{k x 1}) vector with standard deviation of process in each regime.
  \item phi: Vector of autoregressive coefficients.
  \item P: A (\code{k x k}) transition matrix (columns must sum to one).
  \item eps: An optional (\code{T+burnin x q}) matrix with standard normal errors to be used. Errors will be generated if not provided.
  \item Z: A (\code{T x qz}) matrix with exogenous regressors (Optional) and where qz is the number of exogenous variables.
  \item betaZ: A (\code{qz x 1}) matrix  true coefficients on exogenous regressors (Optional) and where qz is the number of exogenous variables.
}}

\item{burnin}{Number of simulated observations to remove from beginning. Default is \code{100}.}
}
\value{
List with simulated Markov-switching autoregressive process and its DGP properties.
}
\description{
This function simulates a Markov-switching autoregressive process.
}
\examples{
set.seed(1234)
# Define DGP of MS AR process
mdl_ms2 <- list(n     = 500, 
                mu    = c(5,10),
                sigma = c(1,2),
                phi   = c(0.5, 0.2),
                k     = 2,
                P     = rbind(c(0.90, 0.10),
                              c(0.10, 0.90)))

# Simulate process using simuMSAR() function
y_ms_simu <- simuMSAR(mdl_ms2)

plot(y_ms_simu)
}
