% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICSKAT_fit_null_PO.R
\name{ICSKAT_fit_null_PO}
\alias{ICSKAT_fit_null_PO}
\title{ICSKAT_fit_null_PO.R}
\usage{
ICSKAT_fit_null_PO(
  init_beta,
  left_dmat,
  right_dmat,
  obs_ind,
  tpos_ind,
  lt,
  rt,
  checkpoint = FALSE,
  eps = 10^(-6)
)
}
\arguments{
\item{init_beta}{(p+nknots+2)*1 vector of coefficients to initialize the Newton-Raphson.}

\item{left_dmat}{n*(p+nknots+2) design matrix for left end of interval.}

\item{right_dmat}{n*(p+nknots+2) design matrix for right end of interval.}

\item{obs_ind}{n*1 vector of whether the event was observed before last follow-up.}

\item{tpos_ind}{n*1 vector of whether the event was observed after follow-up started (t>0).}

\item{lt}{n*1 vector of left side of interval times.}

\item{rt}{n*1 vector of right side of interval times.}

\item{checkpoint}{Boolean tells the function to print when each iteration completes.}

\item{eps}{Stop when the L2 norm of the difference in model coefficients reaches this limit.}
}
\value{
A list with the elements:
\item{beta_fit}{(p+nknots+2)*1 vector of fitted coefficients under null model.}
\item{iter}{Number of iterations needed to converge.}
\item{Itt}{Fisher information matrix for the fitted coefficients.}
\item{diff_beta}{Difference between beta_fit and previous iteration of the vector, can be checked for errors.}
\item{err}{err=1 if NA shows up in the calculation.}
\item{IterrMsg}{Describes the error.}
}
\description{
Fit the null model (cubic basis spline for baseline cumulative hazard and coefficients
for non-genetic coefficients) for interval-censored skat with PO model.
}
\examples{
set.seed(2)
xMat <- matrix(data=rnorm(200), nrow=100)
bhFunInv <- function(x) {x}
obsTimes <- 1:5
etaVec <- rep(0, 100)
outcomeDat <- gen_IC_data(bhFunInv = bhFunInv, obsTimes = obsTimes, windowHalf = 0.1,
probMiss = 0.1, etaVec = etaVec)
lt <- outcomeDat$leftTimes
rt <- outcomeDat$rightTimes
tpos_ind <- as.numeric(lt > 0)
obs_ind <- as.numeric(rt != Inf)
dmats <- make_IC_dmat(xMat = xMat, lt = lt, rt = rt, obs_ind = obs_ind,
tpos_ind = tpos_ind)
ICSKAT_fit_null_PO(init_beta = rep(0.1, 5), left_dmat = dmats$left_dmat,
right_dmat=dmats$right_dmat, obs_ind = obs_ind, tpos_ind = tpos_ind, lt = lt, rt = rt)
}
