% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ger_indices.R
\name{ger_UNC}
\alias{ger_UNC}
\title{Germination Uncertainty}
\usage{
ger_UNC(evalName, data)
}
\arguments{
\item{evalName}{Prefix of the names of the periods of evaluation.}

\item{data}{The name of the data frame containing the data.}
}
\value{
It returns an vector with the values of Germination Uncertainty.
}
\description{
This function calculates the germination uncertainty in the germination process.
}
\details{
The uncertainty index \code{u} is an adaptation of Shannon index measures the degree of uncertainty in predicting the informational
entropy or uncertainty associated with the distribution of the relative frequency of germination (GOUVEA LABOURIAU 1983; LABOURIAU; VALADARES, 1983).
Low values of \code{u} indicate frequencies with short peaks, i.e. the more concentrated the germination in time.
Just a germinated seed changes the value of \code{u}. This means that \code{u} measures the degree of germination scattering.
}
\examples{
library(GerminaR)
dfr <- prosopis
unc <- ger_UNC(evalName = "D", data = dfr)
unc
}
\references{
GOUVEA LABOURIAU, L. L. G. L. A germinacao das sementes. Washington.
LABOURIAU, L. G.; VALADARES, M. E. B. The germination of seeds. OEA, Washington, DC, 1983.
}
