% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tefi.compare.R
\name{tefi.compare}
\alias{tefi.compare}
\title{Compare Total Entropy Fit Index (\code{\link[EGAnet]{tefi}}) Between Two Structures}
\usage{
tefi.compare(bootega.obj, base, comparison, plot.TEFI = TRUE, ...)
}
\arguments{
\item{bootega.obj}{A \code{\link[EGAnet]{bootEGA}} object}

\item{base}{Numeric (length = columns in original dataset).
A vector representing the base structure to be tested}

\item{comparison}{Numeric (length = columns in original dataset).
A vector representing the structure to be compared against the \code{base} structure}

\item{plot.TEFI}{Boolean (length = 1).
Whether the TEFI comparison and the p-value should be plotted.
Defaults to \code{TRUE}}

\item{...}{Additional arguments that can be passed on to \code{\link[EGAnet]{plot.EGAnet}}.
See \code{Examples} for plotting arguments}
}
\value{
A list containing:

\item{\code{TEFI.df}}{A data frame containing the TEFI values for both structures}

\item{\code{p.value}}{The \emph{p}-value from the non-parametric bootstrap hypothesis test}
}
\description{
This function computes the \code{\link[EGAnet]{tefi}} values for two different structures using
bootstrapped correlation matrices from \code{\link[EGAnet]{bootEGA}} and compares them using a
non-parametric bootstrap test. It also visualizes the distributions of \code{\link[EGAnet]{tefi}} values
for both structures.
}
\details{
The null hypothesis is that the TEFI values obtained in the bootstrapped correlation matrices for the \code{base}
structure are than the TEFI values obtained in the bootstrapped correlation matrices for the \code{comparison} structure.
Therefore, the \emph{p}-value in this bootstrap test can be interpreted as follows:

\itemize{

\item{If the \emph{p}-value less than 0.05: TEFI values for the \code{base} structure tend to be lower
than the \code{comparison} structure, indicating that the former provides a better fit (lower entropy) than the latter}

\item{If the \emph{p}-value is greater than 0.05: TEFI values for the \code{base} structure are not significantly lower than
the \code{comparison} structure, suggesting that both structures may provide similar fits or that \code{comparison} might fit better}

}
}
\examples{
# Obtain data
wmt <- wmt2[,7:24]

\dontrun{
# Perform bootstrap EGA
boot.wmt <- bootEGA(
  data = wmt, iter = 500,
  type = "parametric", ncores = 2
)}

# Perform comparison
comparing_tefi <- tefi.compare(
  boot.wmt,
  base = boot.wmt$EGA$wc, # Compare Walktrap
  comparison = community.detection(
   boot.wmt$EGA$network, algorithm = "louvain"
  ) # With Louvain
)

# Plot options (UVa colors)
plot(
  comparing_tefi,
  base.name = "Walktrap", base.color = "#232D4B",
  comparison.name = "Louvain", comparison.color = "#E57200"
)

}
\author{
Hudson Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
