% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{prior_mixture}
\alias{prior_mixture}
\title{Creates a mixture of prior distributions}
\usage{
prior_mixture(
  prior_list,
  is_null = rep(FALSE, length(prior_list)),
  components = NULL
)
}
\arguments{
\item{prior_list}{a list of prior distributions to be mixed.}

\item{is_null}{a logical vector indicating which of the prior distributions
should be considered as a null distribution. Defaults to \code{rep(FALSE, length(prior_list))}.}

\item{components}{a character vector indicating which of the prior distributions
belong to the same mixture component (this is an alternative specification to the \code{is_null} argument).
Defaults to \code{NULL} (i.e., \code{is_null} is used.}
}
\description{
\code{prior_mixture} creates a mixture of prior distributions.
This is a more generic version of the \code{prior_spike_and_slab} function.
}
\seealso{
\code{\link[=prior]{prior()}}
}
