/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#if !(defined H5B_FRIEND || defined H5B_MODULE)
#error "Do not include this file outside the H5B package!"
#endif

#ifndef H5Bpkg_H
#define H5Bpkg_H

#include "H5Bprivate.h"

#include "H5ACprivate.h" 
#include "H5FLprivate.h" 

#define H5B_NKEY(b, shared, idx) ((b)->native + (shared)->nkey[(idx)])

#define LEVEL_BITS 8

#define H5B_UNKNOWN_NODELEVEL -1

typedef struct H5B_t {
    H5AC_info_t cache_info; 
                            
    H5UC_t  *rc_shared;     
    unsigned level;         
    unsigned nchildren;     
    haddr_t  left;          
    haddr_t  right;         
    uint8_t *native;        
    haddr_t *child;         
} H5B_t;

typedef struct H5B_cache_ud_t {
    H5F_t                    *f;         
    const struct H5B_class_t *type;      
    int                       exp_level; 
    H5UC_t                   *rc_shared; 
} H5B_cache_ud_t;

H5FL_SEQ_EXTERN(haddr_t);

H5FL_BLK_EXTERN(native_block);

H5FL_EXTERN(H5B_t);

H5_DLL herr_t H5B__node_dest(H5B_t *bt);

H5_DLL herr_t H5B__verify_structure(H5F_t *f, haddr_t addr, const H5B_class_t *type, void *udata);

#endif 
