/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dbai.pdfwrap.model.document;

import at.ac.tuwien.dbai.pdfwrap.model.document.GenericSegment;
import at.ac.tuwien.dbai.pdfwrap.utils.Utils;
import java.awt.Color;

public class LineSegment
extends GenericSegment {
    public static final int DIR_HORIZ = 1;
    public static final int DIR_VERT = 2;
    public static final int DIR_OTHER = 0;
    protected Color color;
    boolean isCurve = false;
    protected int direction;

    public LineSegment(float x1, float x2, float y1, float y2) {
        super(x1, x2, y1, y2);
        this.direction = Utils.within(y1, y2, 1.0f) ? 1 : (Utils.within(x1, x2, 1.0f) ? 2 : 0);
    }

    public String getNodeText() {
        return "[Line]";
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public float getL1() {
        if (this.direction == 1) {
            return this.x1;
        }
        if (this.direction == 2) {
            return this.y1;
        }
        return -1.0f;
    }

    public float getL2() {
        if (this.direction == 1) {
            return this.x2;
        }
        if (this.direction == 2) {
            return this.y2;
        }
        return -1.0f;
    }

    public float getT() {
        if (this.direction == 1) {
            return (this.y1 + this.y2) / 2.0f;
        }
        if (this.direction == 2) {
            return (this.x1 + this.x2) / 2.0f;
        }
        return -1.0f;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean isCurve() {
        return this.isCurve;
    }

    public void setCurve(boolean isCurve) {
        this.isCurve = isCurve;
    }
}

