/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import java.util.Collections;
import java.util.Set;
import javax.measure.Unit;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.crs.DefaultParametricCRS;
import org.apache.sis.referencing.cs.DefaultParametricCS;
import org.apache.sis.referencing.datum.DefaultParametricDatum;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.iso.AbstractFactory;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

public abstract class GeodeticAuthorityFactory
extends AbstractFactory
implements AuthorityFactory {
    protected GeodeticAuthorityFactory() {
    }

    @Override
    public abstract Citation getAuthority();

    public Set<String> getCodeSpaces() {
        String string = Citations.getCodeSpace(this.getAuthority());
        return string != null ? Collections.singleton(string) : Collections.emptySet();
    }

    @Override
    public InternationalString getDescriptionText(String string) throws FactoryException {
        return new SimpleInternationalString(this.createObject(string).getName().getCode());
    }

    @Override
    public abstract IdentifiedObject createObject(String var1) throws NoSuchAuthorityCodeException, FactoryException;

    public CoordinateReferenceSystem createCoordinateReferenceSystem(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(CoordinateReferenceSystem.class, this.createObject(string), string);
    }

    public GeographicCRS createGeographicCRS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(GeographicCRS.class, this.createCoordinateReferenceSystem(string), string);
    }

    public GeocentricCRS createGeocentricCRS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(GeocentricCRS.class, this.createCoordinateReferenceSystem(string), string);
    }

    public ProjectedCRS createProjectedCRS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(ProjectedCRS.class, this.createCoordinateReferenceSystem(string), string);
    }

    public VerticalCRS createVerticalCRS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(VerticalCRS.class, this.createCoordinateReferenceSystem(string), string);
    }

    public TemporalCRS createTemporalCRS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(TemporalCRS.class, this.createCoordinateReferenceSystem(string), string);
    }

    public DefaultParametricCRS createParametricCRS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(DefaultParametricCRS.class, this.createCoordinateReferenceSystem(string), string);
    }

    public CompoundCRS createCompoundCRS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(CompoundCRS.class, this.createCoordinateReferenceSystem(string), string);
    }

    public DerivedCRS createDerivedCRS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(DerivedCRS.class, this.createCoordinateReferenceSystem(string), string);
    }

    public EngineeringCRS createEngineeringCRS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(EngineeringCRS.class, this.createCoordinateReferenceSystem(string), string);
    }

    public ImageCRS createImageCRS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(ImageCRS.class, this.createCoordinateReferenceSystem(string), string);
    }

    public Datum createDatum(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(Datum.class, this.createObject(string), string);
    }

    public GeodeticDatum createGeodeticDatum(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(GeodeticDatum.class, this.createDatum(string), string);
    }

    public VerticalDatum createVerticalDatum(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(VerticalDatum.class, this.createDatum(string), string);
    }

    public TemporalDatum createTemporalDatum(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(TemporalDatum.class, this.createDatum(string), string);
    }

    public DefaultParametricDatum createParametricDatum(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(DefaultParametricDatum.class, this.createDatum(string), string);
    }

    public EngineeringDatum createEngineeringDatum(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(EngineeringDatum.class, this.createDatum(string), string);
    }

    public ImageDatum createImageDatum(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(ImageDatum.class, this.createDatum(string), string);
    }

    public Ellipsoid createEllipsoid(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(Ellipsoid.class, this.createObject(string), string);
    }

    public PrimeMeridian createPrimeMeridian(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(PrimeMeridian.class, this.createObject(string), string);
    }

    public Extent createExtent(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(Extent.class, this.createObject(string), string);
    }

    public CoordinateSystem createCoordinateSystem(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(CoordinateSystem.class, this.createObject(string), string);
    }

    public EllipsoidalCS createEllipsoidalCS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(EllipsoidalCS.class, this.createCoordinateSystem(string), string);
    }

    public VerticalCS createVerticalCS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(VerticalCS.class, this.createCoordinateSystem(string), string);
    }

    public TimeCS createTimeCS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(TimeCS.class, this.createCoordinateSystem(string), string);
    }

    public DefaultParametricCS createParametricCS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(DefaultParametricCS.class, this.createCoordinateSystem(string), string);
    }

    public CartesianCS createCartesianCS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(CartesianCS.class, this.createCoordinateSystem(string), string);
    }

    public SphericalCS createSphericalCS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(SphericalCS.class, this.createCoordinateSystem(string), string);
    }

    public CylindricalCS createCylindricalCS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(CylindricalCS.class, this.createCoordinateSystem(string), string);
    }

    public PolarCS createPolarCS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(PolarCS.class, this.createCoordinateSystem(string), string);
    }

    public CoordinateSystemAxis createCoordinateSystemAxis(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(CoordinateSystemAxis.class, this.createObject(string), string);
    }

    public Unit<?> createUnit(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(Unit.class, this.createObject(string), string);
    }

    public ParameterDescriptor<?> createParameterDescriptor(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(ParameterDescriptor.class, this.createObject(string), string);
    }

    public OperationMethod createOperationMethod(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(OperationMethod.class, this.createObject(string), string);
    }

    public CoordinateOperation createCoordinateOperation(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(CoordinateOperation.class, this.createObject(string), string);
    }

    public Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String string, String string2) throws NoSuchAuthorityCodeException, FactoryException {
        return Collections.emptySet();
    }

    public IdentifiedObjectFinder newIdentifiedObjectFinder() throws FactoryException {
        return new IdentifiedObjectFinder(this);
    }

    static boolean regionMatches(String string, String string2, int n, int n2) {
        return string.length() == n2 - n && string2.regionMatches(true, n, string, 0, string.length());
    }

    protected final String trimNamespace(String string) {
        int n = string.indexOf(58);
        if (n >= 0) {
            int n2 = CharSequences.skipTrailingWhitespaces(string, 0, n);
            int n3 = CharSequences.skipLeadingWhitespaces(string, 0, n2);
            for (String string2 : this.getCodeSpaces()) {
                if (!GeodeticAuthorityFactory.regionMatches(string2, string, n3, n2)) continue;
                int n4 = string.indexOf(58, n + 1);
                if (n4 >= 0) {
                    n = n4;
                }
                int n5 = string.length();
                return CharSequences.trimWhitespaces(string, n + 1, n5).toString();
            }
        }
        return CharSequences.trimWhitespaces(string);
    }

    private <T> T cast(Class<T> clazz, IdentifiedObject identifiedObject, String string) throws NoSuchAuthorityCodeException {
        if (clazz.isInstance(identifiedObject)) {
            return (T)identifiedObject;
        }
        Class<Object> clazz2 = identifiedObject instanceof AbstractIdentifiedObject ? ((AbstractIdentifiedObject)identifiedObject).getInterface() : identifiedObject.getClass();
        ReferenceIdentifier referenceIdentifier = identifiedObject.getName();
        Citation citation = referenceIdentifier != null ? referenceIdentifier.getAuthority() : this.getAuthority();
        throw new NoSuchAuthorityCodeException(Errors.format((short)143, string, clazz, clazz2), org.apache.sis.internal.util.Citations.getIdentifier(citation, false), this.trimNamespace(string), string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName(this)).append("[\u201c").append(org.apache.sis.internal.util.Citations.getIdentifier(this.getAuthority(), false)).append('\u201d');
        this.toString(stringBuilder);
        return stringBuilder.append(']').toString();
    }

    void toString(StringBuilder stringBuilder) {
    }
}

