/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdfparser.BaseParser;
import org.apache.pdfbox.pdfparser.InputStreamSource;

public class PDFObjectStreamParser
extends BaseParser {
    private static final Log LOG = LogFactory.getLog(PDFObjectStreamParser.class);
    private List<COSObject> streamObjects = null;
    private final COSStream stream;

    public PDFObjectStreamParser(COSStream stream, COSDocument document) throws IOException {
        super(new InputStreamSource(stream.createInputStream()));
        this.stream = stream;
        this.document = document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException {
        try {
            COSBase cosObject;
            int numberOfObjects = this.stream.getInt("N");
            ArrayList<Long> objectNumbers = new ArrayList<Long>(numberOfObjects);
            this.streamObjects = new ArrayList<COSObject>(numberOfObjects);
            for (int i = 0; i < numberOfObjects; ++i) {
                long objectNumber = this.readObjectNumber();
                this.readLong();
                objectNumbers.add(objectNumber);
            }
            int objectCounter = 0;
            while ((cosObject = this.parseDirObject()) != null) {
                COSObject object = new COSObject(cosObject);
                object.setGenerationNumber(0);
                if (objectCounter >= objectNumbers.size()) {
                    LOG.error("/ObjStm (object stream) has more objects than /N " + numberOfObjects);
                    break;
                }
                object.setObjectNumber((Long)objectNumbers.get(objectCounter));
                this.streamObjects.add(object);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("parsed=" + object);
                }
                if (!this.seqSource.isEOF() && this.seqSource.peek() == 101) {
                    this.readLine();
                }
                ++objectCounter;
            }
        }
        finally {
            this.seqSource.close();
        }
    }

    public List<COSObject> getObjects() {
        return this.streamObjects;
    }
}

