/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.fdf;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.filespecification.PDFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDSimpleFileSpecification;
import org.apache.pdfbox.pdmodel.fdf.FDFAnnotation;
import org.apache.pdfbox.pdmodel.fdf.FDFAnnotationText;
import org.apache.pdfbox.pdmodel.fdf.FDFField;
import org.apache.pdfbox.pdmodel.fdf.FDFJavaScript;
import org.apache.pdfbox.pdmodel.fdf.FDFPage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FDFDictionary
implements COSObjectable {
    private COSDictionary fdf;

    public FDFDictionary() {
        this.fdf = new COSDictionary();
    }

    public FDFDictionary(COSDictionary fdfDictionary) {
        this.fdf = fdfDictionary;
    }

    public FDFDictionary(Element fdfXML) throws IOException {
        this();
        NodeList nodeList = fdfXML.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            if (child.getTagName().equals("f")) {
                PDSimpleFileSpecification fs = new PDSimpleFileSpecification();
                fs.setFile(child.getAttribute("href"));
                this.setFile(fs);
                continue;
            }
            if (child.getTagName().equals("ids")) {
                COSArray ids = new COSArray();
                String original = child.getAttribute("original");
                String modified = child.getAttribute("modified");
                ids.add(COSString.createFromHexString(original));
                ids.add(COSString.createFromHexString(modified));
                this.setID(ids);
                continue;
            }
            if (child.getTagName().equals("fields")) {
                NodeList fields = child.getChildNodes();
                ArrayList<FDFField> fieldList = new ArrayList<FDFField>();
                for (int f = 0; f < fields.getLength(); ++f) {
                    fieldList.add(new FDFField((Element)fields.item(f)));
                    Node currentNode = fields.item(f);
                    if (!(currentNode instanceof Element) || !((Element)currentNode).getTagName().equals("field")) continue;
                    fieldList.add(new FDFField((Element)fields.item(f)));
                }
                this.setFields(fieldList);
                continue;
            }
            if (!child.getTagName().equals("annots")) continue;
            NodeList annots = child.getChildNodes();
            ArrayList<FDFAnnotationText> annotList = new ArrayList<FDFAnnotationText>();
            for (int j = 0; j < annots.getLength(); ++j) {
                Node annotNode = annots.item(i);
                if (!(annotNode instanceof Element)) continue;
                Element annot = (Element)annotNode;
                if (annot.getNodeName().equals("text")) {
                    annotList.add(new FDFAnnotationText(annot));
                    continue;
                }
                throw new IOException("Error: Unknown annotation type '" + annot.getNodeName());
            }
            this.setAnnotations(annotList);
        }
    }

    public void writeXML(Writer output) throws IOException {
        List fields;
        COSArray ids;
        PDFileSpecification fs = this.getFile();
        if (fs != null) {
            output.write("<f href=\"" + fs.getFile() + "\" />\n");
        }
        if ((ids = this.getID()) != null) {
            COSString original = (COSString)ids.getObject(0);
            COSString modified = (COSString)ids.getObject(1);
            output.write("<ids original=\"" + original.getHexString() + "\" ");
            output.write("modified=\"" + modified.getHexString() + "\" />\n");
        }
        if ((fields = this.getFields()) != null && fields.size() > 0) {
            output.write("<fields>\n");
            for (int i = 0; i < fields.size(); ++i) {
                ((FDFField)fields.get(i)).writeXML(output);
            }
            output.write("</fields>\n");
        }
    }

    public COSBase getCOSObject() {
        return this.fdf;
    }

    public COSDictionary getCOSDictionary() {
        return this.fdf;
    }

    public PDFileSpecification getFile() throws IOException {
        return PDFileSpecification.createFS(this.fdf.getDictionaryObject(COSName.F));
    }

    public void setFile(PDFileSpecification fs) {
        this.fdf.setItem(COSName.F, (COSObjectable)fs);
    }

    public COSArray getID() {
        return (COSArray)this.fdf.getDictionaryObject(COSName.ID);
    }

    public void setID(COSArray id) {
        this.fdf.setItem(COSName.ID, (COSBase)id);
    }

    public List getFields() {
        COSArrayList retval = null;
        COSArray fieldArray = (COSArray)this.fdf.getDictionaryObject(COSName.FIELDS);
        if (fieldArray != null) {
            ArrayList<FDFField> fields = new ArrayList<FDFField>();
            for (int i = 0; i < fieldArray.size(); ++i) {
                fields.add(new FDFField((COSDictionary)fieldArray.getObject(i)));
            }
            retval = new COSArrayList(fields, fieldArray);
        }
        return retval;
    }

    public void setFields(List fields) {
        this.fdf.setItem(COSName.FIELDS, (COSBase)COSArrayList.converterToCOSArray(fields));
    }

    public String getStatus() {
        return this.fdf.getString(COSName.STATUS);
    }

    public void setStatus(String status) {
        this.fdf.setString(COSName.STATUS, status);
    }

    public List getPages() {
        COSArrayList retval = null;
        COSArray pageArray = (COSArray)this.fdf.getDictionaryObject(COSName.PAGES);
        if (pageArray != null) {
            ArrayList<FDFPage> pages = new ArrayList<FDFPage>();
            for (int i = 0; i < pageArray.size(); ++i) {
                pages.add(new FDFPage((COSDictionary)pageArray.get(i)));
            }
            retval = new COSArrayList(pages, pageArray);
        }
        return retval;
    }

    public void setPages(List pages) {
        this.fdf.setItem(COSName.PAGES, (COSBase)COSArrayList.converterToCOSArray(pages));
    }

    public String getEncoding() {
        String encoding = this.fdf.getNameAsString(COSName.ENCODING);
        if (encoding == null) {
            encoding = "PDFDocEncoding";
        }
        return encoding;
    }

    public void setEncoding(String encoding) {
        this.fdf.setName(COSName.ENCODING, encoding);
    }

    public List getAnnotations() throws IOException {
        COSArrayList retval = null;
        COSArray annotArray = (COSArray)this.fdf.getDictionaryObject(COSName.ANNOTS);
        if (annotArray != null) {
            ArrayList<FDFAnnotation> annots = new ArrayList<FDFAnnotation>();
            for (int i = 0; i < annotArray.size(); ++i) {
                annots.add(FDFAnnotation.create((COSDictionary)annotArray.getObject(i)));
            }
            retval = new COSArrayList(annots, annotArray);
        }
        return retval;
    }

    public void setAnnotations(List annots) {
        this.fdf.setItem(COSName.ANNOTS, (COSBase)COSArrayList.converterToCOSArray(annots));
    }

    public COSStream getDifferences() {
        return (COSStream)this.fdf.getDictionaryObject(COSName.DIFFERENCES);
    }

    public void setDifferences(COSStream diff) {
        this.fdf.setItem(COSName.DIFFERENCES, (COSBase)diff);
    }

    public String getTarget() {
        return this.fdf.getString(COSName.TARGET);
    }

    public void setTarget(String target) {
        this.fdf.setString(COSName.TARGET, target);
    }

    public List getEmbeddedFDFs() throws IOException {
        COSArrayList retval = null;
        COSArray embeddedArray = (COSArray)this.fdf.getDictionaryObject(COSName.EMBEDDED_FDFS);
        if (embeddedArray != null) {
            ArrayList<PDFileSpecification> embedded = new ArrayList<PDFileSpecification>();
            for (int i = 0; i < embeddedArray.size(); ++i) {
                embedded.add(PDFileSpecification.createFS(embeddedArray.get(i)));
            }
            retval = new COSArrayList(embedded, embeddedArray);
        }
        return retval;
    }

    public void setEmbeddedFDFs(List embedded) {
        this.fdf.setItem(COSName.EMBEDDED_FDFS, (COSBase)COSArrayList.converterToCOSArray(embedded));
    }

    public FDFJavaScript getJavaScript() {
        FDFJavaScript fs = null;
        COSDictionary dic = (COSDictionary)this.fdf.getDictionaryObject(COSName.JAVA_SCRIPT);
        if (dic != null) {
            fs = new FDFJavaScript(dic);
        }
        return fs;
    }

    public void setJavaScript(FDFJavaScript js) {
        this.fdf.setItem(COSName.JAVA_SCRIPT, (COSObjectable)js);
    }
}

