/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.filter.Filter;

public class JPXFilter
implements Filter {
    private static final Log log = LogFactory.getLog(JPXFilter.class);

    public void decode(InputStream compressedData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        BufferedImage bi = ImageIO.read(compressedData);
        if (bi != null) {
            DataBuffer dBuf = bi.getData().getDataBuffer();
            if (dBuf.getDataType() == 0) {
                result.write(((DataBufferByte)dBuf).getData());
            } else {
                log.error("Image data buffer not of type byte but type " + dBuf.getDataType());
            }
        }
    }

    public void encode(InputStream rawData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        System.err.println("Warning: JPXFilter.encode is not implemented yet, skipping this stream.");
    }
}

