#!perl

use strict;                     # Import test functions
use warnings;

use Test::More tests => 51;

use Math::Polynomial::Chebyshev;

my $coef =
  [
   [ 1 ],
   [ 0, 1 ],
   [ -1, 0, 2 ],
   [ 0, -3, 0, 4 ],
   [ 1, 0, -8, 0, 8 ],
   [ 0, 5, 0, -20, 0, 16 ],
   [ -1, 0, 18, 0, -48, 0, 32 ],
   [ 0, -7, 0, 56, 0, -112, 0, 64 ],
   [ 1, 0, -32, 0, 160, 0, -256, 0, 128 ],
   [ 0, 9, 0, -120, 0, 432, 0, -576, 0, 256 ],
  ];

my $extr =
  [
   [
    0,
   ],

   [
    -1,
    1,
   ],

   [
    -1,
    0,
    1,
   ],

   [
    -1,
    -5e-1,
    5e-1,
    1,
   ],

   [
    -1,
    -7.071067811865475e-1,
    0,
    7.071067811865475e-1,
    1,
   ],

   [
    -1,
    -8.090169943749474e-1,
    -3.090169943749474e-1,
    3.090169943749474e-1,
    8.090169943749474e-1,
    1,
   ],

   [
    -1,
    -8.660254037844386e-1,
    -5e-1,
    0,
    5e-1,
    8.660254037844386e-1,
    1,
   ],

   [
    -1,
    -9.009688679024191e-1,
    -6.234898018587335e-1,
    -2.225209339563144e-1,
    2.225209339563144e-1,
    6.234898018587335e-1,
    9.009688679024191e-1,
    1,
   ],

   [
    -1,
    -9.238795325112868e-1,
    -7.071067811865475e-1,
    -3.826834323650898e-1,
    0,
    3.826834323650898e-1,
    7.071067811865475e-1,
    9.238795325112868e-1,
    1,
   ],

   [
    -1,
    -9.396926207859084e-1,
    -7.660444431189780e-1,
    -5e-1,
    -1.736481776669303e-1,
    1.736481776669303e-1,
    5e-1,
    7.660444431189780e-1,
    9.396926207859084e-1,
    1,
   ],
  ];

my $root =
  [
   [
   ],

   [
    0,
   ],

   [
    -7.071067811865475e-1,
    7.071067811865475e-1,
   ],

   [
    -8.660254037844386e-1,
    0,
    8.660254037844386e-1,
   ],

   [
    -9.238795325112868e-1,
    -3.826834323650898e-1,
    3.826834323650898e-1,
    9.238795325112868e-1,
   ],

   [
    -9.510565162951536e-1,
    -5.877852522924731e-1,
    0,
    5.877852522924731e-1,
    9.510565162951536e-1,
   ],

   [
    -9.659258262890683e-1,
    -7.071067811865475e-1,
    -2.588190451025208e-1,
    2.588190451025208e-1,
    7.071067811865475e-1,
    9.659258262890683e-1,
   ],

   [
    -9.749279121818236e-1,
    -7.818314824680298e-1,
    -4.338837391175581e-1,
    0,
    4.338837391175581e-1,
    7.818314824680298e-1,
    9.749279121818236e-1,
   ],

   [
    -9.807852804032304e-1,
    -8.314696123025452e-1,
    -5.555702330196022e-1,
    -1.950903220161283e-1,
    1.950903220161283e-1,
    5.555702330196022e-1,
    8.314696123025452e-1,
    9.807852804032304e-1,
   ],

   [
    -9.848077530122081e-1,
    -8.660254037844386e-1,
    -6.427876096865393e-1,
    -3.420201433256687e-1,
    0,
    3.420201433256687e-1,
    6.427876096865393e-1,
    8.660254037844386e-1,
    9.848077530122081e-1,
   ],
  ];

isa_ok('Math::Polynomial::Chebyshev', 'Math::Polynomial');

for (my $i = 0 ; $i <= $#$coef ; ++$i) {
    my $p = Math::Polynomial::Chebyshev -> chebyshev($i);

    isa_ok($p, 'Math::Polynomial::Chebyshev');
    isa_ok($p, 'Math::Polynomial');

    my $coef_got = [ $p -> coefficients() ];
    my $coef_expected = $coef -> [$i];

    subtest "coefficients of T($i)" => sub {
        plan tests => 1 + @$coef_expected;

        cmp_ok(scalar(@$coef_got), '==', scalar(@$coef_expected));
        for (my $j = 0 ; $j <= $#$coef_expected ; ++$j) {
            my $diff = abs($coef_got -> [$j] - $coef_expected -> [$j]);
            cmp_ok($diff, '<=', 1e-15, "coefficient $j");
        }
    };

    my $extr_got = [ $p -> extremas() ];
    my $extr_expected = $extr -> [$i];

    subtest "extremas of T($i)" => sub {
        plan tests => 1 + @$extr_expected;

        cmp_ok(scalar(@$extr_got), '==', scalar(@$extr_expected));
        for (my $j = 0 ; $j <= $#$extr_expected ; ++$j) {
            my $diff = abs($extr_got -> [$j] - $extr_expected -> [$j]);
            cmp_ok($diff, '<=', 1e-15, "extrema $j");
        }
    };

    my $root_got = [ $p -> roots() ];
    my $root_expected = $root -> [$i];

    subtest "roots of T($i)" => sub {
        plan tests => 1 + @$root_expected;

        cmp_ok(scalar(@$root_got), '==', scalar(@$root_expected));
        for (my $j = 0 ; $j <= $#$root_expected ; ++$j) {
            my $diff = abs($root_got -> [$j] - $root_expected -> [$j]);
            cmp_ok($diff, '<=', 1e-15, "root $j");
        }
    };
}
