package Mason::Plugin;
$Mason::Plugin::VERSION = '2.22';
use Mason::PluginRole;
use Mason::Util qw(can_load);
use Class::Load;

method requires_plugins ($plugin_class:) {
    return ();
}

method expand_to_plugins ($plugin_class:) {
    return ( $plugin_class,
        Mason::PluginManager->process_plugin_specs( [ $plugin_class->requires_plugins ] ) );
}

method get_roles_for_mason_class ($plugin_class: $name) {
    my @roles_to_try = join( "::", $plugin_class, $name );
    if ( $name eq 'Component' ) {
        push( @roles_to_try, join( "::", $plugin_class, 'Filters' ) );
    }
    my @roles = grep { Class::Load::is_class_loaded($_) || can_load($_) } @roles_to_try;
    return @roles;
}

1;
