/*
 * Copyright (c) 1983, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Edward Wang at The University of California, Berkeley.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static char sccsid[] = "@(#)wwpty.c	8.1 (Berkeley) 6/6/93";
static char rcsid[] =
  "$FreeBSD: stable/5/usr.bin/window/wwpty.c 84096 2001-09-28 22:46:13Z billf $";
#endif /* not lint */

#include "ww.h"
#include <fcntl.h>
#include <stdlib.h>
#if !defined(OLD_TTY) && !defined(TIOCPKT)
#include <sys/ioctl.h>
#endif

wwgetpty(w)
register struct ww *w;
{
	char *ttyname;
	int master, slave, on;
#define PTY "/dev/XtyXX"

	on = 1;
	w->ww_pty = -1;

	ttyname = malloc(strlen(PTY) + 1);
	if (openpty(&master, &slave, ttyname, NULL, NULL) == 0) {
		w->ww_pty = master;
		(void) strcpy(w->ww_ttyname, ttyname);
		if (ioctl(w->ww_pty, TIOCPKT, (char *)&on) < 0) {
			(void) close(w->ww_pty);
			wwerrno = WWE_SYS;
		} else {
			(void) fcntl(w->ww_pty, F_SETFD, 1);
			free(ttyname);
			return 0;
		}
	}
	free(ttyname);

	wwerrno = WWE_NOPTY;
	return -1;
}
