#!/bin/sh

# Fatal trap 12: page fault while in kernel mode
# cpuid = 10; apic id = 0a
# fault virtual address   = 0x0
# fault code              = supervisor read data, page not present
# instruction pointer     = 0x20:0xffffffff80e04f35
# stack pointer           = 0x28:0xfffffe014fd0fbc0
# frame pointer           = 0x28:0xfffffe014fd0fc00
# code segment            = base 0x0, limit 0xfffff, type 0x1b
#                         = DPL 0, pres 1, long 1, def32 0, gran 1
# processor eflags        = interrupt enabled, resume, IOPL = 0
# current process         = 13332 (repro77)
# trap number             = 12
# panic: page fault
# cpuid = 10
# time = 1640585179
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe014fd0f980
# vpanic() at vpanic+0x17f/frame 0xfffffe014fd0f9d0
# panic() at panic+0x43/frame 0xfffffe014fd0fa30
# trap_fatal() at trap_fatal+0x385/frame 0xfffffe014fd0fa90
# trap_pfault() at trap_pfault+0xab/frame 0xfffffe014fd0faf0
# calltrap() at calltrap+0x8/frame 0xfffffe014fd0faf0
# --- trap 0xc, rip = 0xffffffff80e04f35, rsp = 0xfffffe014fd0fbc0, rbp = 0xfffffe014fd0fc00 ---
# tcp_usr_rcvd() at tcp_usr_rcvd+0x65/frame 0xfffffe014fd0fc00
# soreceive_generic() at soreceive_generic+0xe44/frame 0xfffffe014fd0fcc0
# soreceive() at soreceive+0x4b/frame 0xfffffe014fd0fce0
# kern_recvit() at kern_recvit+0x1ba/frame 0xfffffe014fd0fd90
# sys_recvmsg() at sys_recvmsg+0x6f/frame 0xfffffe014fd0fe00
# amd64_syscall() at amd64_syscall+0x145/frame 0xfffffe014fd0ff30
# fast_syscall_common() at fast_syscall_common+0xf8/frame 0xfffffe014fd0ff30
# --- syscall (0, FreeBSD ELF64, nosys), rip = 0x8020e328a, rsp = 0x22f48, rbp = 0x22f70 ---
# KDB: enter: panic
# [ thread pid 13332 tid 103311 ]
# Stopped at      kdb_enter+0x37: movq    $0,0x128720e(%rip)
# db> x/s version
# version: FreeBSD 14.0-CURRENT #0 ufs-n251956-c3008785b91: Mon Dec 27 06:11:30 CET 2021
# pho@mercat1.netperf.freebsd.org:/var/tmp/deviant3/sys/amd64/compile/PHO
# db> 

. ../default.cfg
[ `id -u` -ne 0 ] && echo "Must be root!" && exit 1

cat > /tmp/syzkaller49.c <<EOF
// https://syzkaller.appspot.com/bug?id=efb2e9f019f36fbc39380724a31cb0c458bb4e61
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// Reported-by: syzbot+93c75c4618b2a4f0f0ac@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <errno.h>
#include <pthread.h>
#include <pwd.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <time.h>
#include <unistd.h>

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void thread_start(void* (*fn)(void*), void* arg)
{
  pthread_t th;
  pthread_attr_t attr;
  pthread_attr_init(&attr);
  pthread_attr_setstacksize(&attr, 128 << 10);
  int i = 0;
  for (; i < 100; i++) {
    if (pthread_create(&th, &attr, fn, arg) == 0) {
      pthread_attr_destroy(&attr);
      return;
    }
    if (errno == EAGAIN) {
      usleep(50);
      continue;
    }
    break;
  }
  exit(1);
}

typedef struct {
  pthread_mutex_t mu;
  pthread_cond_t cv;
  int state;
} event_t;

static void event_init(event_t* ev)
{
  if (pthread_mutex_init(&ev->mu, 0))
    exit(1);
  if (pthread_cond_init(&ev->cv, 0))
    exit(1);
  ev->state = 0;
}

static void event_reset(event_t* ev)
{
  ev->state = 0;
}

static void event_set(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  if (ev->state)
    exit(1);
  ev->state = 1;
  pthread_mutex_unlock(&ev->mu);
  pthread_cond_broadcast(&ev->cv);
}

static void event_wait(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  while (!ev->state)
    pthread_cond_wait(&ev->cv, &ev->mu);
  pthread_mutex_unlock(&ev->mu);
}

static int event_isset(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

static int event_timedwait(event_t* ev, uint64_t timeout)
{
  uint64_t start = current_time_ms();
  uint64_t now = start;
  pthread_mutex_lock(&ev->mu);
  for (;;) {
    if (ev->state)
      break;
    uint64_t remain = timeout - (now - start);
    struct timespec ts;
    ts.tv_sec = remain / 1000;
    ts.tv_nsec = (remain % 1000) * 1000 * 1000;
    pthread_cond_timedwait(&ev->cv, &ev->mu, &ts);
    now = current_time_ms();
    if (now - start > timeout)
      break;
  }
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

struct thread_t {
  int created, call;
  event_t ready, done;
};

static struct thread_t threads[16];
static void execute_call(int call);
static int running;

static void* thr(void* arg)
{
  struct thread_t* th = (struct thread_t*)arg;
  for (;;) {
    event_wait(&th->ready);
    event_reset(&th->ready);
    execute_call(th->call);
    __atomic_fetch_sub(&running, 1, __ATOMIC_RELAXED);
    event_set(&th->done);
  }
  return 0;
}

static void loop(void)
{
  int i, call, thread;
  for (call = 0; call < 6; call++) {
    for (thread = 0; thread < (int)(sizeof(threads) / sizeof(threads[0]));
         thread++) {
      struct thread_t* th = &threads[thread];
      if (!th->created) {
        th->created = 1;
        event_init(&th->ready);
        event_init(&th->done);
        event_set(&th->done);
        thread_start(thr, th);
      }
      if (!event_isset(&th->done))
        continue;
      event_reset(&th->done);
      th->call = call;
      __atomic_fetch_add(&running, 1, __ATOMIC_RELAXED);
      event_set(&th->ready);
      event_timedwait(&th->done, 50);
      break;
    }
  }
  for (i = 0; i < 100 && __atomic_load_n(&running, __ATOMIC_RELAXED); i++)
    sleep_ms(1);
}

uint64_t r[1] = {0xffffffffffffffff};

void execute_call(int call)
{
  intptr_t res = 0;
  switch (call) {
  case 0:
    res = syscall(SYS_socket, 2ul, 1ul, 0);
    if (res != -1)
      r[0] = res;
    break;
  case 1:
    *(uint8_t*)0x20000140 = 0x10;
    *(uint8_t*)0x20000141 = 2;
    *(uint16_t*)0x20000142 = htobe16(0x4e23);
    *(uint32_t*)0x20000144 = htobe32(0x7f000001);
    memset((void*)0x20000148, 0, 8);
    syscall(SYS_bind, r[0], 0x20000140ul, 0x10ul);
    break;
  case 2:
    *(uint8_t*)0x20000080 = 0x10;
    *(uint8_t*)0x20000081 = 2;
    *(uint16_t*)0x20000082 = htobe16(0x4e23);
    *(uint32_t*)0x20000084 = htobe32(0x7f000001);
    memset((void*)0x20000088, 0, 8);
    syscall(SYS_sendto, r[0], 0ul, 0ul, 0ul, 0x20000080ul, 0x10ul);
    break;
  case 3:
    memset((void*)0x20000100, 69, 1);
    syscall(SYS_sendto, r[0], 0x20000100ul, 0xfda4ul, 0ul, 0ul, 0ul);
    break;
  case 4:
    *(uint64_t*)0x200003c0 = 0;
    *(uint32_t*)0x200003c8 = 0;
    *(uint64_t*)0x200003d0 = 0x20000340;
    *(uint64_t*)0x20000340 = 0x20000680;
    *(uint64_t*)0x20000348 = 0x19000;
    *(uint64_t*)0x200003d8 = 1;
    *(uint64_t*)0x200003e0 = 0;
    *(uint64_t*)0x200003e8 = 0;
    *(uint32_t*)0x200003f0 = 0;
    syscall(SYS_recvmsg, r[0], 0x200003c0ul, 0x40ul);
    break;
  case 5:
    syscall(SYS_shutdown, r[0], 1ul);
    break;
  }
}
int main(void)
{
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 7ul, 0x1012ul, -1, 0ul);
  loop();
  return 0;
}
EOF

set -e
mount | grep "on $mntpoint " | grep -q /dev/md && umount -f $mntpoint
[ -c /dev/md$mdstart ] &&  mdconfig -d -u $mdstart
mdconfig -a -t swap -s 5g -u $mdstart
newfs $newfs_flags -n md$mdstart > /dev/null
mount /dev/md$mdstart $mntpoint
set +e

mkdir $mntpoint/work
mycc -o $mntpoint/work/syzkaller49 -Wall -Wextra -O0 /tmp/syzkaller49.c -lpthread || exit 1

start=`date +%s`
while [ $((`date +%s` - start)) -lt 120 ]; do
	(cd $mntpoint/work; ./syzkaller49)
done

for i in `jot 6`; do
	mount | grep -q "on $mntpoint " || break
	umount $mntpoint && break || sleep 10
	[ $i -eq 6 ] &&
	    { echo FATAL; fstat -mf $mntpoint; exit 1; }
done
mdconfig -d -u $mdstart

rm -rf /tmp/syzkaller49.c
exit 0
