#include <sys/param.h>
#include <sys/event.h>

#include <err.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

int
main(int argc, char **argv)
{
	int fd, kq, n;
	struct kevent event[1];

	if (argc != 2)
		errx(1, "Usage: %s file", argv[0]);
	
	fd = open(argv[1], O_RDONLY);
	if (fd < 0)
		err(1, "open: %s", argv[1]);

        kq = kqueue();
        if (kq < 0)
                err(1, "kqueue");

	event[0].ident = fd;
	event[0].filter = EVFILT_AIO;
	event[0].flags = EV_ADD | EV_ENABLE;
	n = kevent(kq, event, 1, NULL, 0, NULL);
	if (n < 0)
		err(1, "kevent create");
	
	for (;;) {
		n = kevent(kq, NULL, 0, event, 1, NULL);
		if (n < 0)
			err(1, "kevent(2)");
		printf("kevent flags: 0x%x, data: 0x%lx\n",
		    event[0].flags, event[0].data);
	}
}
