/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.actions;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.cheatsheets.OpenCheatSheetAction;
import org.eclipse.ui.internal.cheatsheets.CheatSheetHistory;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.actions.CheatSheetCategoryBasedSelectionAction;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetCollectionElement;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetElement;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetRegistryReader;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetView;

public class CheatSheetMenu
extends ContributionItem {
    private static final int MAX_CHEATSHEET_ITEMS = 5;
    private static CheatSheetRegistryReader reg;
    private boolean showActive = false;
    private Comparator comparator = new Comparator(){
        private Collator collator = Collator.getInstance();

        public int compare(Object ob1, Object ob2) {
            if (ob1 == null || ob2 == null) {
                return -1;
            }
            CheatSheetElement d1 = (CheatSheetElement)((Object)ob1);
            CheatSheetElement d2 = (CheatSheetElement)((Object)ob2);
            return this.collator.compare(d1.getLabel(null), d2.getLabel(null));
        }
    };

    public CheatSheetMenu() {
        super("LaunchCheatSheetMenu");
        if (reg == null) {
            reg = CheatSheetRegistryReader.getInstance();
        }
        this.showActive(true);
    }

    private void createMenuItem(Menu menu, int index, final CheatSheetElement element, boolean bCheck) {
        MenuItem mi = new MenuItem(menu, bCheck ? 16 : 8, index);
        mi.setText(element.getLabel(null));
        mi.setSelection(bCheck);
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheatSheetMenu.this.run(element, e);
            }
        });
    }

    private void createOtherItem(Menu menu, int index) {
        MenuItem mi = new MenuItem(menu, 8, index);
        mi.setText(CheatSheetPlugin.getResourceString("%CHEAT_SHEET_OTHER_MENU"));
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheatSheetMenu.this.runOther(e);
            }
        });
    }

    public void fill(Menu menu, int index) {
        String checkID = null;
        if (this.showActive) {
            checkID = this.getActiveCheatSheetID();
        }
        ArrayList cheatsheets = this.getCheatSheetItems();
        Collections.sort(cheatsheets, this.comparator);
        for (int i = 0; i < cheatsheets.size(); ++i) {
            CheatSheetElement element = (CheatSheetElement)((Object)cheatsheets.get(i));
            if (element == null) continue;
            this.createMenuItem(menu, index++, element, element.getID().equals(checkID));
        }
        if (cheatsheets.size() > 0) {
            ++index;
            new MenuItem(menu, 2, index);
        }
        this.createOtherItem(menu, index);
    }

    private String getActiveCheatSheetID() {
        CheatSheetElement content;
        CheatSheetView view;
        IWorkbenchPage page = this.getActiveWorkbenchPage();
        if (page != null && (view = (CheatSheetView)page.findView("org.eclipse.ui.cheatsheets.views.CheatSheetView")) != null && (content = view.getContent()) != null) {
            return content.getID();
        }
        return null;
    }

    private IWorkbenchPage getActiveWorkbenchPage() {
        IWorkbench workbench = CheatSheetPlugin.getPlugin().getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        return window.getActivePage();
    }

    protected ArrayList getCheatSheetItems() {
        ArrayList list = new ArrayList(5);
        int emptySlots = 5;
        if (emptySlots > 0) {
            ArrayList mru = new ArrayList(5);
            int count = this.getCheatSheetMru(mru, 0, 5);
            for (int i = 0; i < count && emptySlots > 0; ++i) {
                if (list.contains(mru.get(i))) continue;
                list.add(mru.get(i));
                --emptySlots;
            }
        }
        CheatSheetCollectionElement cheatSheetsCollection = (CheatSheetCollectionElement)reg.getCheatSheets();
        emptySlots = this.addCheatSheets(list, cheatSheetsCollection, emptySlots);
        return list;
    }

    private int addCheatSheets(ArrayList list, CheatSheetCollectionElement cheatSheetsCollection, int emptySlots) {
        Object[] cheatSheets = cheatSheetsCollection.getCheatSheets();
        for (int i = 0; i < cheatSheets.length && emptySlots > 0; ++i) {
            if (list.contains(cheatSheets[i])) continue;
            list.add(cheatSheets[i]);
            --emptySlots;
        }
        Object[] cheatSheetsFromCollection = cheatSheetsCollection.getChildren();
        for (int nX = 0; nX < cheatSheetsFromCollection.length && emptySlots > 0; ++nX) {
            CheatSheetCollectionElement collection = (CheatSheetCollectionElement)((Object)cheatSheetsFromCollection[nX]);
            emptySlots = this.addCheatSheets(list, collection, emptySlots);
        }
        return emptySlots;
    }

    private int getCheatSheetMru(List dest, int destStart, int count) {
        CheatSheetHistory history = CheatSheetPlugin.getPlugin().getCheatSheetHistory();
        return history.copyItems(dest, destStart, count);
    }

    protected boolean getShowActive() {
        return this.showActive;
    }

    public boolean isDynamic() {
        return true;
    }

    public boolean isVisible() {
        return this.getActiveWorkbenchPage() != null;
    }

    protected void run(CheatSheetElement element, SelectionEvent event) {
        new OpenCheatSheetAction(element.getID()).run();
    }

    private void runOther(SelectionEvent event) {
        new CheatSheetCategoryBasedSelectionAction().run();
    }

    protected void showActive(boolean b) {
        this.showActive = b;
    }
}

