/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.startup.TldRuleSet;
import org.apache.catalina.startup.WebRuleSet;
import org.apache.catalina.util.StringManager;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public final class ContextConfig
implements LifecycleListener {
    private static ResourceBundle authenticators = null;
    private Context context = null;
    private int debug = 0;
    private boolean ok = false;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    private static Digester tldDigester = ContextConfig.createTldDigester();
    private static Digester webDigester = ContextConfig.createWebDigester();
    static /* synthetic */ Class class$org$apache$catalina$startup$ContextConfig;

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            int contextDebug;
            this.context = (Context)((Object)event.getLifecycle());
            if (this.context instanceof StandardContext && (contextDebug = ((StandardContext)this.context).getDebug()) > this.debug) {
                this.debug = contextDebug;
            }
        }
        catch (ClassCastException e) {
            this.log(sm.getString("contextConfig.cce", event.getLifecycle()), e);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void applicationConfig() {
        InputStream stream = null;
        ServletContext servletContext = this.context.getServletContext();
        if (servletContext != null) {
            stream = servletContext.getResourceAsStream("/WEB-INF/web.xml");
        }
        if (stream == null) {
            this.log(sm.getString("contextConfig.applicationMissing"));
            return;
        }
        Digester digester = webDigester;
        synchronized (digester) {
            block20: {
                URL url = servletContext.getResource("/WEB-INF/web.xml");
                InputSource is = new InputSource(url.toExternalForm());
                is.setByteStream(stream);
                webDigester.setDebug(this.getDebug());
                if (this.context instanceof StandardContext) {
                    ((StandardContext)this.context).setReplaceWelcomeFiles(true);
                }
                webDigester.clear();
                webDigester.push((Object)this.context);
                webDigester.parse(is);
                Object var7_8 = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    break block20;
                }
                catch (IOException e2) {
                    this.log(sm.getString("contextConfig.applicationClose"), e2);
                }
                break block20;
                {
                    catch (SAXParseException e) {
                        this.log(sm.getString("contextConfig.applicationParse"), e);
                        this.log(sm.getString("contextConfig.applicationPosition", "" + e.getLineNumber(), "" + e.getColumnNumber()));
                        this.ok = false;
                        Object var7_9 = null;
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                            break block20;
                        }
                        catch (IOException e2) {
                            this.log(sm.getString("contextConfig.applicationClose"), e2);
                        }
                        break block20;
                    }
                    catch (Exception e) {
                        this.log(sm.getString("contextConfig.applicationParse"), e);
                        this.ok = false;
                        Object var7_10 = null;
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                            break block20;
                        }
                        catch (IOException e2) {
                            this.log(sm.getString("contextConfig.applicationClose"), e2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException e2) {
                        this.log(sm.getString("contextConfig.applicationClose"), e2);
                    }
                    throw throwable;
                }
            }
        }
    }

    private synchronized void authenticatorConfig() {
        SecurityConstraint[] constraints = this.context.findConstraints();
        if (constraints == null || constraints.length == 0) {
            return;
        }
        LoginConfig loginConfig = this.context.getLoginConfig();
        if (loginConfig == null) {
            loginConfig = new LoginConfig("NONE", null, null, null);
            this.context.setLoginConfig(loginConfig);
        }
        if (this.context instanceof Authenticator) {
            return;
        }
        if (this.context instanceof ContainerBase) {
            Pipeline pipeline = ((ContainerBase)((Object)this.context)).getPipeline();
            if (pipeline != null) {
                Valve basic = pipeline.getBasic();
                if (basic != null && basic instanceof Authenticator) {
                    return;
                }
                Valve[] valves = pipeline.getValves();
                for (int i = 0; i < valves.length; ++i) {
                    if (!(valves[i] instanceof Authenticator)) continue;
                    return;
                }
            }
        } else {
            return;
        }
        if (this.context.getRealm() == null) {
            this.log(sm.getString("contextConfig.missingRealm"));
            this.ok = false;
            return;
        }
        if (authenticators == null) {
            try {
                authenticators = ResourceBundle.getBundle("org.apache.catalina.startup.Authenticators");
            }
            catch (MissingResourceException e) {
                this.log(sm.getString("contextConfig.authenticatorResources"), e);
                this.ok = false;
                return;
            }
        }
        String authenticatorName = null;
        try {
            authenticatorName = authenticators.getString(loginConfig.getAuthMethod());
        }
        catch (MissingResourceException e) {
            authenticatorName = null;
        }
        if (authenticatorName == null) {
            this.log(sm.getString("contextConfig.authenticatorMissing", loginConfig.getAuthMethod()));
            this.ok = false;
            return;
        }
        Valve authenticator = null;
        try {
            Pipeline pipeline;
            Class<?> authenticatorClass = Class.forName(authenticatorName);
            authenticator = (Valve)authenticatorClass.newInstance();
            if (this.context instanceof ContainerBase && (pipeline = ((ContainerBase)((Object)this.context)).getPipeline()) != null) {
                ((ContainerBase)((Object)this.context)).addValve(authenticator);
                this.log(sm.getString("contextConfig.authenticatorConfigured", loginConfig.getAuthMethod()));
            }
        }
        catch (Throwable t) {
            this.log(sm.getString("contextConfig.authenticatorInstantiate", authenticatorName), t);
            this.ok = false;
        }
    }

    private void certificatesConfig() {
        boolean secure = false;
        Container container = this.context.getParent();
        if (container instanceof Host) {
            container = container.getParent();
        }
        if (container instanceof Engine) {
            Service service = ((Engine)container).getService();
            if (service == null) {
                secure = true;
            } else {
                Connector[] connectors = service.findConnectors();
                for (int i = 0; i < connectors.length && !(secure = connectors[i].getSecure()); ++i) {
                }
            }
        }
        if (!secure) {
            return;
        }
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass("javax.net.ssl.SSLSocket");
            if (clazz == null) {
                return;
            }
        }
        catch (Throwable certificates) {
            return;
        }
        Valve certificates = null;
        try {
            Class<?> clazz = Class.forName("org.apache.catalina.valves.CertificatesValve");
            certificates = (Valve)clazz.newInstance();
        }
        catch (Throwable t) {
            return;
        }
        try {
            Pipeline pipeline;
            if (this.context instanceof ContainerBase && (pipeline = ((ContainerBase)((Object)this.context)).getPipeline()) != null) {
                ((ContainerBase)((Object)this.context)).addValve(certificates);
                this.log(sm.getString("contextConfig.certificatesConfig.added"));
            }
        }
        catch (Throwable t) {
            this.log(sm.getString("contextConfig.certificatesConfig.error"), t);
            this.ok = false;
        }
    }

    private static Digester createTldDigester() {
        URL url = null;
        Digester tldDigester = new Digester();
        tldDigester.setValidating(true);
        url = (class$org$apache$catalina$startup$ContextConfig == null ? (class$org$apache$catalina$startup$ContextConfig = ContextConfig.class$("org.apache.catalina.startup.ContextConfig")) : class$org$apache$catalina$startup$ContextConfig).getResource("/javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd");
        tldDigester.register("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN", url.toString());
        url = (class$org$apache$catalina$startup$ContextConfig == null ? (class$org$apache$catalina$startup$ContextConfig = ContextConfig.class$("org.apache.catalina.startup.ContextConfig")) : class$org$apache$catalina$startup$ContextConfig).getResource("/javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd");
        tldDigester.register("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN", url.toString());
        tldDigester.addRuleSet((RuleSet)new TldRuleSet());
        return tldDigester;
    }

    private static Digester createWebDigester() {
        URL url = null;
        Digester webDigester = new Digester();
        webDigester.setValidating(true);
        url = (class$org$apache$catalina$startup$ContextConfig == null ? (class$org$apache$catalina$startup$ContextConfig = ContextConfig.class$("org.apache.catalina.startup.ContextConfig")) : class$org$apache$catalina$startup$ContextConfig).getResource("/javax/servlet/resources/web-app_2_2.dtd");
        webDigester.register("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", url.toString());
        url = (class$org$apache$catalina$startup$ContextConfig == null ? (class$org$apache$catalina$startup$ContextConfig = ContextConfig.class$("org.apache.catalina.startup.ContextConfig")) : class$org$apache$catalina$startup$ContextConfig).getResource("/javax/servlet/resources/web-app_2_3.dtd");
        webDigester.register("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", url.toString());
        webDigester.addRuleSet((RuleSet)new WebRuleSet());
        return webDigester;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void defaultConfig() {
        File file = new File("conf/web.xml");
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), "conf/web.xml");
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file.getCanonicalPath());
            stream.close();
            stream = null;
        }
        catch (FileNotFoundException e) {
            this.log(sm.getString("contextConfig.defaultMissing"));
            return;
        }
        catch (IOException e) {
            this.log(sm.getString("contextConfig.defaultMissing"), e);
            return;
        }
        Digester digester = webDigester;
        synchronized (digester) {
            block22: {
                InputSource is = new InputSource("file://" + file.getAbsolutePath());
                stream = new FileInputStream(file);
                is.setByteStream(stream);
                webDigester.setDebug(this.getDebug());
                if (this.context instanceof StandardContext) {
                    ((StandardContext)this.context).setReplaceWelcomeFiles(true);
                }
                webDigester.clear();
                webDigester.push((Object)this.context);
                webDigester.parse(is);
                Object var6_9 = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    break block22;
                }
                catch (IOException e2) {
                    this.log(sm.getString("contextConfig.defaultClose"), e2);
                }
                break block22;
                {
                    catch (SAXParseException e) {
                        this.log(sm.getString("contextConfig.defaultParse"), e);
                        this.log(sm.getString("contextConfig.defaultPosition", "" + e.getLineNumber(), "" + e.getColumnNumber()));
                        this.ok = false;
                        Object var6_10 = null;
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                            break block22;
                        }
                        catch (IOException e2) {
                            this.log(sm.getString("contextConfig.defaultClose"), e2);
                        }
                        break block22;
                    }
                    catch (Exception e) {
                        this.log(sm.getString("contextConfig.defaultParse"), e);
                        this.ok = false;
                        Object var6_11 = null;
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                            break block22;
                        }
                        catch (IOException e2) {
                            this.log(sm.getString("contextConfig.defaultClose"), e2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_12 = null;
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException e2) {
                        this.log(sm.getString("contextConfig.defaultClose"), e2);
                    }
                    throw throwable;
                }
            }
        }
    }

    private void log(String message) {
        Logger logger = null;
        if (this.context != null) {
            logger = this.context.getLogger();
        }
        if (logger != null) {
            logger.log("ContextConfig[" + this.context.getName() + "]: " + message);
        } else {
            System.out.println("ContextConfig[" + this.context.getName() + "]: " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = null;
        if (this.context != null) {
            logger = this.context.getLogger();
        }
        if (logger != null) {
            logger.log("ContextConfig[" + this.context.getName() + "] " + message, throwable);
        } else {
            System.out.println("ContextConfig[" + this.context.getName() + "]: " + message);
            System.out.println("" + throwable);
            throwable.printStackTrace(System.out);
        }
    }

    private synchronized void start() {
        if (this.debug > 0) {
            this.log(sm.getString("contextConfig.start"));
        }
        this.context.setConfigured(false);
        this.ok = true;
        Container container = this.context.getParent();
        if (!this.context.getOverride()) {
            if (container instanceof Host) {
                ((Host)container).importDefaultContext(this.context);
                container = container.getParent();
            }
            if (container instanceof Engine) {
                ((Engine)container).importDefaultContext(this.context);
            }
        }
        this.defaultConfig();
        this.applicationConfig();
        if (this.ok) {
            this.validateSecurityRoles();
        }
        if (this.ok) {
            try {
                this.tldScan();
            }
            catch (Exception e) {
                this.log(e.getMessage(), e);
                this.ok = false;
            }
        }
        if (this.ok) {
            this.certificatesConfig();
        }
        if (this.ok) {
            this.authenticatorConfig();
        }
        if (this.debug >= 1 && this.context instanceof ContainerBase) {
            this.log("Pipline Configuration:");
            Pipeline pipeline = ((ContainerBase)((Object)this.context)).getPipeline();
            Valve[] valves = null;
            if (pipeline != null) {
                valves = pipeline.getValves();
            }
            if (valves != null) {
                for (int i = 0; i < valves.length; ++i) {
                    this.log("  " + valves[i].getInfo());
                }
            }
            this.log("======================");
        }
        if (this.ok) {
            this.context.setConfigured(true);
        } else {
            this.log(sm.getString("contextConfig.unavailable"));
            this.context.setConfigured(false);
        }
    }

    private synchronized void stop() {
        int i;
        if (this.debug > 0) {
            this.log(sm.getString("contextConfig.stop"));
        }
        Container[] children = this.context.findChildren();
        for (i = 0; i < children.length; ++i) {
            this.context.removeChild(children[i]);
        }
        String[] applicationListeners = this.context.findApplicationListeners();
        for (i = 0; i < applicationListeners.length; ++i) {
            this.context.removeApplicationListener(applicationListeners[i]);
        }
        ApplicationParameter[] applicationParameters = this.context.findApplicationParameters();
        for (i = 0; i < applicationParameters.length; ++i) {
            this.context.removeApplicationParameter(applicationParameters[i].getName());
        }
        SecurityConstraint[] securityConstraints = this.context.findConstraints();
        for (i = 0; i < securityConstraints.length; ++i) {
            this.context.removeConstraint(securityConstraints[i]);
        }
        ErrorPage[] errorPages = this.context.findErrorPages();
        for (i = 0; i < errorPages.length; ++i) {
            this.context.removeErrorPage(errorPages[i]);
        }
        FilterDef[] filterDefs = this.context.findFilterDefs();
        for (i = 0; i < filterDefs.length; ++i) {
            this.context.removeFilterDef(filterDefs[i]);
        }
        FilterMap[] filterMaps = this.context.findFilterMaps();
        for (i = 0; i < filterMaps.length; ++i) {
            this.context.removeFilterMap(filterMaps[i]);
        }
        String[] instanceListeners = this.context.findInstanceListeners();
        for (i = 0; i < instanceListeners.length; ++i) {
            this.context.removeInstanceListener(instanceListeners[i]);
        }
        String[] mimeMappings = this.context.findMimeMappings();
        for (i = 0; i < mimeMappings.length; ++i) {
            this.context.removeMimeMapping(mimeMappings[i]);
        }
        String[] parameters = this.context.findParameters();
        for (i = 0; i < parameters.length; ++i) {
            this.context.removeParameter(parameters[i]);
        }
        String[] securityRoles = this.context.findSecurityRoles();
        for (i = 0; i < securityRoles.length; ++i) {
            this.context.removeSecurityRole(securityRoles[i]);
        }
        String[] servletMappings = this.context.findServletMappings();
        for (i = 0; i < servletMappings.length; ++i) {
            this.context.removeServletMapping(servletMappings[i]);
        }
        String[] taglibs = this.context.findTaglibs();
        for (i = 0; i < taglibs.length; ++i) {
            this.context.removeTaglib(taglibs[i]);
        }
        String[] welcomeFiles = this.context.findWelcomeFiles();
        for (i = 0; i < welcomeFiles.length; ++i) {
            this.context.removeWelcomeFile(welcomeFiles[i]);
        }
        String[] wrapperLifecycles = this.context.findWrapperLifecycles();
        for (i = 0; i < wrapperLifecycles.length; ++i) {
            this.context.removeWrapperLifecycle(wrapperLifecycles[i]);
        }
        String[] wrapperListeners = this.context.findWrapperListeners();
        for (i = 0; i < wrapperListeners.length; ++i) {
            this.context.removeWrapperListener(wrapperListeners[i]);
        }
        this.ok = true;
    }

    private void tldScan() throws Exception {
        Set resourcePaths = this.tldScanResourcePaths();
        Iterator paths = resourcePaths.iterator();
        while (paths.hasNext()) {
            String path = (String)paths.next();
            if (path.endsWith(".jar")) {
                this.tldScanJar(path);
                continue;
            }
            this.tldScanTld(path);
        }
    }

    /*
     * Loose catch block
     */
    private void tldScanJar(String resourcePath) throws Exception {
        block17: {
            InputStream inputStream;
            String name;
            JarFile jarFile;
            block15: {
                if (this.debug >= 1) {
                    this.log(" Scanning JAR at resource path '" + resourcePath + "'");
                }
                jarFile = null;
                name = null;
                inputStream = null;
                URL url = this.context.getServletContext().getResource(resourcePath);
                if (url == null) {
                    throw new IllegalArgumentException(sm.getString("contextConfig.tldResourcePath", resourcePath));
                }
                url = new URL("jar:" + url.toString() + "!/");
                JarURLConnection conn = (JarURLConnection)url.openConnection();
                conn.setUseCaches(false);
                jarFile = conn.getJarFile();
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    name = entry.getName();
                    if (!name.startsWith("META-INF/") || !name.endsWith(".tld")) continue;
                    if (this.debug >= 2) {
                        this.log("  Processing TLD at '" + name + "'");
                    }
                    inputStream = jarFile.getInputStream(entry);
                    this.tldScanStream(inputStream);
                    inputStream.close();
                    inputStream = null;
                    name = null;
                }
                Object var10_10 = null;
                if (inputStream == null) break block15;
                try {
                    inputStream.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                inputStream = null;
            }
            if (jarFile != null) {
                jarFile = null;
            }
            break block17;
            {
                catch (Exception e) {
                    if (name == null) {
                        throw new ServletException(sm.getString("contextConfig.tldJarException", resourcePath), (Throwable)e);
                    }
                    throw new ServletException(sm.getString("contextConfig.tldEntryException", name, resourcePath), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    inputStream = null;
                }
                if (jarFile != null) {
                    jarFile = null;
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tldScanStream(InputStream resourceStream) throws Exception {
        Digester digester = tldDigester;
        synchronized (digester) {
            tldDigester.clear();
            tldDigester.push((Object)this.context);
            tldDigester.parse(resourceStream);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tldScanTld(String resourcePath) throws Exception {
        if (this.debug >= 1) {
            this.log(" Scanning TLD at resource path '" + resourcePath + "'");
        }
        InputStream inputStream = null;
        try {
            try {
                inputStream = this.context.getServletContext().getResourceAsStream(resourcePath);
                if (inputStream == null) {
                    throw new IllegalArgumentException(sm.getString("contextConfig.tldResourcePath", resourcePath));
                }
                this.tldScanStream(inputStream);
                inputStream.close();
                return;
            }
            catch (Exception e) {
                throw new ServletException(sm.getString("contextConfig.tldFileException", resourcePath), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            inputStream = null;
            throw throwable;
        }
    }

    private Set tldScanResourcePaths() throws IOException {
        String resourcePath;
        NameClassPair item;
        NamingEnumeration<NameClassPair> items;
        if (this.debug >= 1) {
            this.log(" Accumulating TLD resource paths");
        }
        HashSet<String> resourcePaths = new HashSet<String>();
        if (this.debug >= 2) {
            this.log("  Scanning <taglib> elements in web.xml");
        }
        String[] taglibs = this.context.findTaglibs();
        for (int i = 0; i < taglibs.length; ++i) {
            String resourcePath2 = this.context.findTaglib(taglibs[i]);
            if (!resourcePath2.startsWith("/")) {
                resourcePath2 = "/WEB-INF/" + resourcePath2;
            }
            if (this.debug >= 3) {
                this.log("   Adding path '" + resourcePath2 + "' for URI '" + taglibs[i] + "'");
            }
            resourcePaths.add(resourcePath2);
        }
        if (this.debug >= 2) {
            this.log("  Scanning TLDs in /WEB-INF subdirectory");
        }
        DirContext resources = this.context.getResources();
        try {
            items = resources.list("/WEB-INF");
            while (items.hasMoreElements()) {
                item = (NameClassPair)items.nextElement();
                resourcePath = "/WEB-INF/" + item.getName();
                if (!resourcePath.endsWith(".tld")) continue;
                if (this.debug >= 3) {
                    this.log("   Adding path '" + resourcePath + "'");
                }
                resourcePaths.add(resourcePath);
            }
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (this.debug >= 2) {
            this.log("  Scanning JARs in /WEB-INF/lib subdirectory");
        }
        try {
            items = resources.list("/WEB-INF/lib");
            while (items.hasMoreElements()) {
                item = (NameClassPair)items.nextElement();
                resourcePath = "/WEB-INF/lib/" + item.getName();
                if (!resourcePath.endsWith(".jar")) continue;
                if (this.debug >= 3) {
                    this.log("   Adding path '" + resourcePath + "'");
                }
                resourcePaths.add(resourcePath);
            }
        }
        catch (NamingException e) {
            // empty catch block
        }
        return resourcePaths;
    }

    private void validateSecurityRoles() {
        SecurityConstraint[] constraints = this.context.findConstraints();
        for (int i = 0; i < constraints.length; ++i) {
            String[] roles = constraints[i].findAuthRoles();
            for (int j = 0; j < roles.length; ++j) {
                if ("*".equals(roles[j]) || this.context.findSecurityRole(roles[j])) continue;
                this.log(sm.getString("contextConfig.role.auth", roles[j]));
                this.context.addSecurityRole(roles[j]);
            }
        }
        Container[] wrappers = this.context.findChildren();
        for (int i = 0; i < wrappers.length; ++i) {
            Wrapper wrapper = (Wrapper)wrappers[i];
            String runAs = wrapper.getRunAs();
            if (runAs != null && !this.context.findSecurityRole(runAs)) {
                this.log(sm.getString("contextConfig.role.runas", runAs));
                this.context.addSecurityRole(runAs);
            }
            String[] names = wrapper.findSecurityReferences();
            for (int j = 0; j < names.length; ++j) {
                String link = wrapper.findSecurityReference(names[j]);
                if (link == null || this.context.findSecurityRole(link)) continue;
                this.log(sm.getString("contextConfig.role.link", link));
                this.context.addSecurityRole(link);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

