/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.Assert;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class JarSelectionValidator
implements ISelectionStatusValidator {
    private Class[] fAcceptedTypes;
    private boolean fAllowMultipleSelection;

    public JarSelectionValidator(Class[] acceptedTypes, boolean allowMultipleSelection) {
        Assert.isNotNull((Object)acceptedTypes);
        this.fAcceptedTypes = acceptedTypes;
        this.fAllowMultipleSelection = allowMultipleSelection;
    }

    public IStatus validate(Object[] elements) {
        if (this.isValidSelection(elements)) {
            return new Status(0, PDEPlugin.getPluginId(), 0, "", null);
        }
        return new Status(4, PDEPlugin.getPluginId(), 4, "", null);
    }

    private boolean isValidSelection(Object[] selection) {
        if (selection.length == 0) {
            return false;
        }
        if (!this.fAllowMultipleSelection && selection.length != 1) {
            return false;
        }
        for (int i = 0; i < selection.length; ++i) {
            Object o = selection[i];
            if (this.isValid(o)) continue;
            return false;
        }
        return true;
    }

    public boolean isValid(Object element) {
        for (int i = 0; i < this.fAcceptedTypes.length; ++i) {
            if (!this.fAcceptedTypes[i].isInstance(element)) continue;
            return true;
        }
        return false;
    }
}

