/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.ToggleFilterAction;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.help.WorkbenchHelp;

public class ShowSupportedBreakpointsAction
extends ToggleFilterAction
implements ISelectionListener {
    private IViewPart fView;
    private List fDebugTargets = new ArrayList(2);
    static /* synthetic */ Class class$org$eclipse$debug$core$model$IDebugTarget;

    public ShowSupportedBreakpointsAction(StructuredViewer viewer, IViewPart view) {
        this.setText(ActionMessages.getString("ShowSupportedBreakpointsAction.Show_For_Selected"));
        this.setToolTipText(ActionMessages.getString("ShowSupportedBreakpointsAction.tooltip"));
        this.setViewerFilter(new BreakpointFilter());
        this.setViewer(viewer);
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_OBJS_DEBUG_TARGET"));
        this.setChecked(false);
        this.setId(DebugUIPlugin.getUniqueIdentifier() + ".ShowSupportedBreakpointsAction");
        this.setView(view);
        WorkbenchHelp.setHelp((IAction)this, (String)IDebugHelpContextIds.SHOW_BREAKPOINTS_FOR_MODEL_ACTION);
    }

    public void dispose() {
        if (this.isChecked()) {
            this.getView().getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            List debugTargets = this.getDebugTargets(ss);
            if (!this.isChecked()) {
                this.fDebugTargets = debugTargets;
                return;
            }
            if (debugTargets.isEmpty()) {
                if (this.fDebugTargets.isEmpty()) {
                    return;
                }
                this.reapplyFilters(debugTargets);
                return;
            }
            if (this.fDebugTargets.isEmpty()) {
                this.reapplyFilters(debugTargets);
                return;
            }
            if (debugTargets.size() == this.fDebugTargets.size()) {
                ArrayList<IDebugTarget> copy = new ArrayList<IDebugTarget>(debugTargets.size());
                Iterator iter = this.fDebugTargets.iterator();
                while (iter.hasNext()) {
                    IDebugTarget target = (IDebugTarget)iter.next();
                    Iterator newDebugTargets = debugTargets.iterator();
                    while (newDebugTargets.hasNext()) {
                        IDebugTarget newTarget = (IDebugTarget)newDebugTargets.next();
                        copy.add(newTarget);
                        if (!target.equals(newTarget)) continue;
                        newDebugTargets.remove();
                    }
                }
                if (debugTargets.isEmpty()) {
                    return;
                }
                this.reapplyFilters(copy);
            }
        }
    }

    protected void reapplyFilters(List debugTargets) {
        this.fDebugTargets = debugTargets;
        this.getViewer().refresh();
        ((BreakpointsView)this.getView()).initializeCheckedState();
    }

    protected IViewPart getView() {
        return this.fView;
    }

    protected void setView(IViewPart view) {
        this.fView = view;
    }

    protected List getDebugTargets(IStructuredSelection ss) {
        ArrayList<IDebugTarget> debugTargets = new ArrayList<IDebugTarget>(2);
        Iterator i = ss.iterator();
        while (i.hasNext()) {
            IDebugTarget target;
            Object next = i.next();
            if (next instanceof IDebugElement) {
                debugTargets.add(((IDebugElement)next).getDebugTarget());
                continue;
            }
            if (next instanceof ILaunch) {
                IDebugTarget[] targets = ((ILaunch)next).getDebugTargets();
                for (int j = 0; j < targets.length; ++j) {
                    debugTargets.add(targets[j]);
                }
                continue;
            }
            if (!(next instanceof IProcess) || (target = (IDebugTarget)((IProcess)next).getAdapter(class$org$eclipse$debug$core$model$IDebugTarget == null ? ShowSupportedBreakpointsAction.class$("org.eclipse.debug.core.model.IDebugTarget") : class$org$eclipse$debug$core$model$IDebugTarget)) == null) continue;
            debugTargets.add(target);
        }
        return debugTargets;
    }

    protected void valueChanged(boolean on) {
        if (this.getViewer().getControl().isDisposed()) {
            return;
        }
        if (on) {
            this.getView().getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
            ISelection selection = this.getView().getSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
            this.selectionChanged(null, selection);
        } else {
            this.getView().getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        }
        super.valueChanged(on);
        if (!on) {
            ((BreakpointsView)this.getView()).initializeCheckedState();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class BreakpointFilter
    extends ViewerFilter {
        BreakpointFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            IBreakpoint breakpoint = (IBreakpoint)element;
            if (ShowSupportedBreakpointsAction.this.fDebugTargets.isEmpty()) {
                return true;
            }
            Iterator iterator = ShowSupportedBreakpointsAction.this.fDebugTargets.iterator();
            while (iterator.hasNext()) {
                IDebugTarget target = (IDebugTarget)iterator.next();
                if (!target.supportsBreakpoint(breakpoint)) continue;
                return true;
            }
            return false;
        }
    }
}

