/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.codemanipulation.AddGetterSetterOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.codemanipulation.IRequestQuery;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.dialogs.SourceActionDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.WorkbenchHelp;

public class AddGetterSetterAction
extends SelectionDispatchAction {
    private boolean fSort;
    private boolean fSynchronized;
    private boolean fFinal;
    private int fVisibility;
    private boolean fGenerateComment;
    private int fNumEntries;
    private CompilationUnitEditor fEditor;
    private static final String DIALOG_TITLE = ActionMessages.getString("AddGetterSetterAction.error.title");
    static /* synthetic */ Class class$org$eclipse$jface$text$IRewriteTarget;

    public AddGetterSetterAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.getString("AddGetterSetterAction.label"));
        this.setDescription(ActionMessages.getString("AddGetterSetterAction.description"));
        this.setToolTipText(ActionMessages.getString("AddGetterSetterAction.tooltip"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.getter_setter_action_context");
    }

    public AddGetterSetterAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(editor) != null);
        this.fEditor.getEditorSite();
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection selection) {
        try {
            IField[] selectedFields = this.getSelectedFields(selection);
            if (AddGetterSetterAction.canRunOn(selectedFields)) {
                this.run(selectedFields[0].getDeclaringType(), selectedFields, false);
                return;
            }
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IType) {
                this.run((IType)firstElement, new IField[0], false);
            } else if (firstElement instanceof ICompilationUnit) {
                IType type = ((ICompilationUnit)firstElement).findPrimaryType();
                if (type.isInterface()) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.getString("AddGetterSetterAction.interface_not_applicable"));
                    return;
                }
                this.run(((ICompilationUnit)firstElement).findPrimaryType(), new IField[0], false);
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), DIALOG_TITLE, ActionMessages.getString("AddGetterSetterAction.error.actionfailed"));
        }
    }

    private boolean canEnable(IStructuredSelection selection) throws JavaModelException {
        if (this.getSelectedFields(selection) != null) {
            return true;
        }
        if (selection.size() == 1 && selection.getFirstElement() instanceof IType) {
            IType type = (IType)selection.getFirstElement();
            return type.getCompilationUnit() != null && type.isClass() && !type.isLocal();
        }
        return selection.size() == 1 && selection.getFirstElement() instanceof ICompilationUnit;
    }

    private static boolean canRunOn(IField[] fields) {
        return fields != null && fields.length > 0;
    }

    private void resetNumEntries() {
        this.fNumEntries = 0;
    }

    private void incNumEntries() {
        ++this.fNumEntries;
    }

    private void run(IType type, IField[] preselected, boolean editor) throws CoreException {
        int dialogResult;
        if (type.isInterface()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.getString("AddGetterSetterAction.interface_not_applicable"));
            return;
        }
        if (!ElementValidator.check((IJavaElement)type, this.getShell(), DIALOG_TITLE, editor)) {
            return;
        }
        if (!ActionUtil.isProcessable(this.getShell(), type)) {
            return;
        }
        AddGetterSetterLabelProvider lp = new AddGetterSetterLabelProvider();
        this.resetNumEntries();
        Map entries = this.createGetterSetterMapping(type);
        if (entries.isEmpty()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.getString("AddGettSetterAction.typeContainsNoFields.message"));
            return;
        }
        AddGetterSetterContentProvider cp = new AddGetterSetterContentProvider(entries);
        GetterSetterTreeSelectionDialog dialog = new GetterSetterTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, cp, this.fEditor, type);
        dialog.setSorter(new JavaElementSorter());
        dialog.setTitle(DIALOG_TITLE);
        String message = ActionMessages.getString("AddGetterSetterAction.dialog.label");
        dialog.setMessage(message);
        dialog.setValidator(AddGetterSetterAction.createValidator(this.fNumEntries));
        dialog.setContainerMode(true);
        dialog.setSize(60, 18);
        dialog.setInput(type);
        if (preselected.length > 0) {
            dialog.setInitialSelections(preselected);
            cp.setPreselected(preselected[0]);
        }
        if ((dialogResult = dialog.open()) == 0) {
            IField[] getterSetterFields;
            IField[] setterFields;
            IField[] getterFields;
            Object[] result = dialog.getResult();
            if (result == null) {
                return;
            }
            this.fSort = dialog.getSortOrder();
            this.fSynchronized = dialog.getSynchronized();
            this.fFinal = dialog.getFinal();
            this.fVisibility = dialog.getVisibilityModifier();
            this.fGenerateComment = dialog.getGenerateComment();
            if (this.fSort) {
                getterFields = AddGetterSetterAction.getGetterFields(result);
                setterFields = AddGetterSetterAction.getSetterFields(result);
                getterSetterFields = new IField[]{};
            } else {
                getterFields = AddGetterSetterAction.getGetterOnlyFields(result);
                setterFields = AddGetterSetterAction.getSetterOnlyFields(result);
                getterSetterFields = AddGetterSetterAction.getGetterSetterFields(result);
            }
            IJavaElement elementPosition = dialog.getElementPosition();
            this.generate(getterFields, setterFields, getterSetterFields, elementPosition);
        }
    }

    private static String createSignatureKey(String methodName, IField field) throws JavaModelException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(methodName);
        String fieldType = field.getTypeSignature();
        String signature = Signature.getSimpleName((String)Signature.toString((String)fieldType));
        buffer.append("#");
        buffer.append(signature);
        return buffer.toString();
    }

    private static ISelectionStatusValidator createValidator(int entries) {
        AddGetterSetterSelectionStatusValidator validator = new AddGetterSetterSelectionStatusValidator(entries);
        return validator;
    }

    private static IField[] getSetterFields(Object[] result) {
        ArrayList<IField> list = new ArrayList<IField>(0);
        Object each = null;
        GetterSetterEntry entry = null;
        for (int i = 0; i < result.length; ++i) {
            each = result[i];
            if (!(each instanceof GetterSetterEntry)) continue;
            entry = (GetterSetterEntry)each;
            if (entry.fGetterEntry) continue;
            list.add(entry.fField);
        }
        return list.toArray(new IField[list.size()]);
    }

    private static IField[] getGetterFields(Object[] result) {
        ArrayList<IField> list = new ArrayList<IField>(0);
        Object each = null;
        GetterSetterEntry entry = null;
        for (int i = 0; i < result.length; ++i) {
            each = result[i];
            if (!(each instanceof GetterSetterEntry)) continue;
            entry = (GetterSetterEntry)each;
            if (!entry.fGetterEntry) continue;
            list.add(entry.fField);
        }
        return list.toArray(new IField[list.size()]);
    }

    private static IField[] getGetterOnlyFields(Object[] result) {
        ArrayList<IField> list = new ArrayList<IField>(0);
        Object each = null;
        GetterSetterEntry entry = null;
        boolean getterSet = false;
        for (int i = 0; i < result.length; ++i) {
            each = result[i];
            if (each instanceof GetterSetterEntry) {
                entry = (GetterSetterEntry)each;
                if (entry.fGetterEntry) {
                    list.add(entry.fField);
                    getterSet = true;
                }
                if (entry.fGetterEntry || !getterSet) continue;
                list.remove(entry.fField);
                getterSet = false;
                continue;
            }
            getterSet = false;
        }
        return list.toArray(new IField[list.size()]);
    }

    private static IField[] getSetterOnlyFields(Object[] result) {
        ArrayList<IField> list = new ArrayList<IField>(0);
        Object each = null;
        GetterSetterEntry entry = null;
        boolean getterSet = false;
        for (int i = 0; i < result.length; ++i) {
            each = result[i];
            if (each instanceof GetterSetterEntry) {
                entry = (GetterSetterEntry)each;
                if (entry.fGetterEntry) {
                    getterSet = true;
                }
                if (entry.fGetterEntry || getterSet) continue;
                list.add(entry.fField);
                getterSet = false;
                continue;
            }
            getterSet = false;
        }
        return list.toArray(new IField[list.size()]);
    }

    private static IField[] getGetterSetterFields(Object[] result) {
        ArrayList<IField> list = new ArrayList<IField>(0);
        Object each = null;
        GetterSetterEntry entry = null;
        boolean getterSet = false;
        for (int i = 0; i < result.length; ++i) {
            each = result[i];
            if (each instanceof GetterSetterEntry) {
                entry = (GetterSetterEntry)each;
                if (entry.fGetterEntry) {
                    getterSet = true;
                }
                if (entry.fGetterEntry || !getterSet) continue;
                list.add(entry.fField);
                getterSet = false;
                continue;
            }
            getterSet = false;
        }
        return list.toArray(new IField[list.size()]);
    }

    private void generate(IField[] getterFields, IField[] setterFields, IField[] getterSetterFields, IJavaElement elementPosition) throws CoreException {
        if (getterFields.length == 0 && setterFields.length == 0 && getterSetterFields.length == 0) {
            return;
        }
        ICompilationUnit cu = null;
        cu = getterFields.length != 0 ? getterFields[0].getCompilationUnit() : (setterFields.length != 0 ? setterFields[0].getCompilationUnit() : getterSetterFields[0].getCompilationUnit());
        IEditorPart editor = EditorUtility.openInEditor(cu);
        this.run(cu, getterFields, setterFields, getterSetterFields, editor, elementPosition);
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void run(ITextSelection selection) {
        try {
            IType type;
            if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
                return;
            }
            IJavaElement[] elements = SelectionConverter.codeResolve(this.fEditor);
            if (elements.length == 1 && elements[0] instanceof IField) {
                IField field = (IField)elements[0];
                this.run(field.getDeclaringType(), new IField[]{field}, true);
                return;
            }
            IJavaElement element = SelectionConverter.getElementAtOffset(this.fEditor);
            if (element != null && (type = (IType)element.getAncestor(7)) != null && type.getFields().length > 0) {
                this.run(type, new IField[0], true);
                return;
            }
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.getString("AddGetterSetterAction.not_applicable"));
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), DIALOG_TITLE, ActionMessages.getString("AddGetterSetterAction.error.actionfailed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(ICompilationUnit cu, IField[] getterFields, IField[] setterFields, IField[] getterSetterFields, IEditorPart editor, IJavaElement elementPosition) {
        IRewriteTarget target = (IRewriteTarget)editor.getAdapter(class$org$eclipse$jface$text$IRewriteTarget == null ? (class$org$eclipse$jface$text$IRewriteTarget = AddGetterSetterAction.class$("org.eclipse.jface.text.IRewriteTarget")) : class$org$eclipse$jface$text$IRewriteTarget);
        if (target != null) {
            target.beginCompoundChange();
        }
        try {
            AddGetterSetterOperation op = this.createAddGetterSetterOperation(getterFields, setterFields, getterSetterFields, elementPosition);
            this.setOperationStatusFields(op);
            Object context = JavaPlugin.getActiveWorkbenchWindow();
            if (context == null) {
                context = new BusyIndicatorRunnableContext();
            }
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, (IRunnableWithProgress)new WorkbenchRunnableAdapter(op, op.getScheduleRule()), op.getScheduleRule());
            IMethod[] createdMethods = op.getCreatedAccessors();
            if (createdMethods.length > 0) {
                EditorUtility.revealInEditor(editor, (IJavaElement)createdMethods[0]);
            }
        }
        catch (InvocationTargetException e) {
            String message = ActionMessages.getString("AddGetterSetterAction.error.actionfailed");
            ExceptionHandler.handle(e, this.getShell(), DIALOG_TITLE, message);
        }
        catch (InterruptedException e) {
        }
        finally {
            if (target != null) {
                target.endCompoundChange();
            }
        }
    }

    private void setOperationStatusFields(AddGetterSetterOperation op) {
        int flags = this.fVisibility;
        if (this.fSynchronized) {
            flags |= 0x20;
        }
        if (this.fFinal) {
            flags |= 0x10;
        }
        op.setSort(this.fSort);
        op.setFlags(flags);
        op.setCreateComments(this.fGenerateComment);
    }

    private AddGetterSetterOperation createAddGetterSetterOperation(IField[] getterFields, IField[] setterFields, IField[] getterSetterFields, IJavaElement elementPosition) {
        IRequestQuery skipSetterForFinalQuery = this.skipSetterForFinalQuery();
        IRequestQuery skipReplaceQuery = this.skipReplaceQuery();
        return new AddGetterSetterOperation(getterFields, setterFields, getterSetterFields, skipSetterForFinalQuery, skipReplaceQuery, elementPosition);
    }

    private IRequestQuery skipSetterForFinalQuery() {
        return new IRequestQuery(){

            public int doQuery(IMember field) {
                int[] returnCodes = new int[]{2, 3, 1, 0};
                String[] options = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                String fieldName = JavaElementLabels.getElementLabel((IJavaElement)field, 0);
                String formattedMessage = ActionMessages.getFormattedString("AddGetterSetterAction.SkipSetterForFinalDialog.message", fieldName);
                return AddGetterSetterAction.this.showQueryDialog(formattedMessage, options, returnCodes);
            }
        };
    }

    private IRequestQuery skipReplaceQuery() {
        return new IRequestQuery(){

            public int doQuery(IMember method) {
                int[] returnCodes = new int[]{2, 1, 3, 0};
                String skipLabel = ActionMessages.getString("AddGetterSetterAction.SkipExistingDialog.skip.label");
                String replaceLabel = ActionMessages.getString("AddGetterSetterAction.SkipExistingDialog.replace.label");
                String skipAllLabel = ActionMessages.getString("AddGetterSetterAction.SkipExistingDialog.skipAll.label");
                String[] options = new String[]{skipLabel, replaceLabel, skipAllLabel, IDialogConstants.CANCEL_LABEL};
                String methodName = JavaElementLabels.getElementLabel((IJavaElement)method, 1);
                String formattedMessage = ActionMessages.getFormattedString("AddGetterSetterAction.SkipExistingDialog.message", methodName);
                return AddGetterSetterAction.this.showQueryDialog(formattedMessage, options, returnCodes);
            }
        };
    }

    private int showQueryDialog(final String message, final String[] buttonLabels, int[] returnCodes) {
        final Shell shell = this.getShell();
        if (shell == null) {
            JavaPlugin.logErrorMessage("AddGetterSetterAction.showQueryDialog: No active shell found");
            return 0;
        }
        final int[] result = new int[]{1};
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                String title = ActionMessages.getString("AddGetterSetterAction.QueryDialog.title");
                MessageDialog dialog = new MessageDialog(shell, title, null, message, 3, buttonLabels, 0);
                result[0] = dialog.open();
            }
        });
        int returnVal = result[0];
        return returnVal < 0 ? 0 : returnCodes[returnVal];
    }

    private IField[] getSelectedFields(IStructuredSelection selection) {
        List elements = selection.toList();
        int nElements = elements.size();
        if (nElements > 0) {
            IField[] res = new IField[nElements];
            ICompilationUnit cu = null;
            for (int i = 0; i < nElements; ++i) {
                IField fld;
                block7: {
                    Object curr = elements.get(i);
                    if (curr instanceof IField) {
                        fld = (IField)curr;
                        if (i == 0 ? (cu = fld.getCompilationUnit()) == null : !cu.equals(fld.getCompilationUnit())) {
                            return null;
                        }
                        try {
                            if (fld.getDeclaringType().isInterface()) {
                                return null;
                            }
                            break block7;
                        }
                        catch (JavaModelException e) {
                            JavaPlugin.log(e);
                            return null;
                        }
                    }
                    return null;
                }
                res[i] = fld;
            }
            return res;
        }
        return null;
    }

    private Map createGetterSetterMapping(IType type) throws JavaModelException {
        IField[] fields = type.getFields();
        HashMap<IField, GetterSetterEntry[]> result = new HashMap<IField, GetterSetterEntry[]>();
        for (int i = 0; i < fields.length; ++i) {
            ArrayList<GetterSetterEntry> l = new ArrayList<GetterSetterEntry>(2);
            if (GetterSetterUtil.getGetter(fields[i]) == null) {
                l.add(new GetterSetterEntry(fields[i], true));
                this.incNumEntries();
            }
            if (GetterSetterUtil.getSetter(fields[i]) == null) {
                l.add(new GetterSetterEntry(fields[i], false));
                this.incNumEntries();
            }
            if (l.isEmpty()) continue;
            result.put(fields[i], l.toArray(new GetterSetterEntry[l.size()]));
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class GetterSetterEntry {
        public final IField fField;
        public final boolean fGetterEntry;

        GetterSetterEntry(IField field, boolean isGetterEntry) {
            this.fField = field;
            this.fGetterEntry = isGetterEntry;
        }
    }

    private static class GetterSetterTreeSelectionDialog
    extends SourceActionDialog {
        private IType fType;
        private AddGetterSetterContentProvider fContentProvider;
        private static final int SELECT_GETTERS_ID = 1025;
        private static final int SELECT_SETTERS_ID = 1026;
        private IDialogSettings fSettings;
        private boolean fSortOrder;
        private final String SETTINGS_SECTION = "AddGetterSetterDialog";
        private final String SORT_ORDER = "SortOrdering";

        public GetterSetterTreeSelectionDialog(Shell parent, ILabelProvider labelProvider, AddGetterSetterContentProvider contentProvider, CompilationUnitEditor editor, IType type) throws JavaModelException {
            super(parent, labelProvider, contentProvider, editor, type, false);
            this.fContentProvider = contentProvider;
            this.fType = type;
            IDialogSettings dialogSettings = JavaPlugin.getDefault().getDialogSettings();
            this.fSettings = dialogSettings.getSection("AddGetterSetterDialog");
            if (this.fSettings == null) {
                this.fSettings = dialogSettings.addNewSection("AddGetterSetterDialog");
                this.fSettings.put("SortOrdering", false);
            }
            this.fSortOrder = this.fSettings.getBoolean("SortOrdering");
        }

        public boolean getSortOrder() {
            return this.fSortOrder;
        }

        public void setSortOrder(boolean sort) {
            if (this.fSortOrder != sort) {
                this.fSortOrder = sort;
                this.fSettings.put("SortOrdering", sort);
                if (this.fContentProvider.fViewer != null) {
                    this.fContentProvider.fViewer.refresh();
                }
            }
        }

        private void createGetterSetterButtons(Composite buttonComposite) {
            this.createButton(buttonComposite, 1025, ActionMessages.getString("GetterSetterTreeSelectionDialog.select_getters"), false);
            this.createButton(buttonComposite, 1026, ActionMessages.getString("GetterSetterTreeSelectionDialog.select_setters"), false);
        }

        protected void buttonPressed(int buttonId) {
            super.buttonPressed(buttonId);
            switch (buttonId) {
                case 1025: {
                    this.getTreeViewer().setCheckedElements(this.getGetterSetterElements(true));
                    this.updateOKStatus();
                    break;
                }
                case 1026: {
                    this.getTreeViewer().setCheckedElements(this.getGetterSetterElements(false));
                    this.updateOKStatus();
                }
            }
        }

        protected Composite createEntryPtCombo(Composite composite) {
            Composite entryComposite = super.createEntryPtCombo(composite);
            this.addSortOrder(entryComposite);
            this.addVisibilityAndModifiersChoices(entryComposite);
            return entryComposite;
        }

        private Composite addSortOrder(Composite composite) {
            Label label = new Label(composite, 0);
            label.setText(ActionMessages.getString("GetterSetterTreeSelectionDialog.sort_label"));
            GridData gd = new GridData(1808);
            label.setLayoutData((Object)gd);
            Combo combo = new Combo(composite, 8);
            combo.setItems(new String[]{ActionMessages.getString("GetterSetterTreeSelectionDialog.alpha_pair_sort"), ActionMessages.getString("GetterSetterTreeSelectionDialog.alpha_method_sort")});
            boolean methodIndex = true;
            int sort = this.getSortOrder() ? 1 : 0;
            combo.setText(combo.getItem(sort));
            gd = new GridData(1808);
            combo.setLayoutData((Object)gd);
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(this, combo){
                private final /* synthetic */ Combo val$combo;
                private final /* synthetic */ GetterSetterTreeSelectionDialog this$0;
                {
                    this.this$0 = this$0;
                    this.val$combo = val$combo;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$0.setSortOrder(this.val$combo.getSelectionIndex() == 1);
                }
            });
            return composite;
        }

        private Object[] getGetterSetterElements(boolean isGetter) {
            Object[] allFields = this.fContentProvider.getElements(null);
            HashSet<GetterSetterEntry> result = new HashSet<GetterSetterEntry>();
            for (int i = 0; i < allFields.length; ++i) {
                IField field = (IField)allFields[i];
                GetterSetterEntry[] entries = this.getEntries(field);
                for (int j = 0; j < entries.length; ++j) {
                    GetterSetterEntry entry = entries[j];
                    if (entry.fGetterEntry != isGetter) continue;
                    result.add(entry);
                }
            }
            return result.toArray();
        }

        private GetterSetterEntry[] getEntries(IField field) {
            List<Object> result = Arrays.asList(this.fContentProvider.getChildren(field));
            return result.toArray(new GetterSetterEntry[result.size()]);
        }

        protected Composite createSelectionButtons(Composite composite) {
            Composite buttonComposite = super.createSelectionButtons(composite);
            GridLayout layout = new GridLayout();
            buttonComposite.setLayout((Layout)layout);
            this.createGetterSetterButtons(buttonComposite);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 1;
            return buttonComposite;
        }

        protected Control createDialogArea(Composite parent) {
            Control control = super.createDialogArea(parent);
            GetterSetterTreeSelectionDialog.applyDialogFont((Control)control);
            try {
                this.getTreeViewer().setExpandedElements((Object[])this.fType.getFields());
                IField preselected = this.fContentProvider.getPreselected();
                if (preselected != null) {
                    this.getTreeViewer().reveal((Object)preselected);
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            return control;
        }
    }

    private static class AddGetterSetterContentProvider
    implements ITreeContentProvider {
        private static final Object[] EMPTY = new Object[0];
        private Viewer fViewer;
        private Map fGetterSetterEntries;
        private IField fPreselected;

        public AddGetterSetterContentProvider(Map entries) {
            this.fGetterSetterEntries = entries;
        }

        public IField getPreselected() {
            return this.fPreselected;
        }

        public void setPreselected(IField preselected) {
            this.fPreselected = preselected;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fViewer = viewer;
        }

        public Viewer getViewer() {
            return this.fViewer;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IField) {
                return (Object[])this.fGetterSetterEntries.get(parentElement);
            }
            return EMPTY;
        }

        public Object getParent(Object element) {
            if (element instanceof IMember) {
                return ((IMember)element).getDeclaringType();
            }
            if (element instanceof GetterSetterEntry) {
                return ((GetterSetterEntry)element).fField;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.fGetterSetterEntries.keySet().toArray();
        }

        public void dispose() {
            this.fGetterSetterEntries.clear();
            this.fGetterSetterEntries = null;
        }
    }

    private static class AddGetterSetterLabelProvider
    extends JavaElementLabelProvider {
        AddGetterSetterLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof GetterSetterEntry) {
                GetterSetterEntry entry = (GetterSetterEntry)element;
                try {
                    if (entry.fGetterEntry) {
                        return GetterSetterUtil.getGetterName(entry.fField, null) + "()";
                    }
                    return GetterSetterUtil.getSetterName(entry.fField, null) + '(' + Signature.getSimpleName((String)Signature.toString((String)entry.fField.getTypeSignature())) + ')';
                }
                catch (JavaModelException e) {
                    return "";
                }
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof GetterSetterEntry) {
                int flags = 0;
                try {
                    flags = ((GetterSetterEntry)element).fField.getFlags();
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
                Object desc = JavaElementImageProvider.getFieldImageDescriptor(false, 1);
                int adornmentFlags = Flags.isStatic((int)flags) ? 8 : 0;
                desc = new JavaElementImageDescriptor((ImageDescriptor)desc, adornmentFlags, JavaElementImageProvider.BIG_SIZE);
                return JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)desc);
            }
            return super.getImage(element);
        }
    }

    private static class AddGetterSetterSelectionStatusValidator
    implements ISelectionStatusValidator {
        private static int fEntries;

        AddGetterSetterSelectionStatusValidator(int entries) {
            fEntries = entries;
        }

        public IStatus validate(Object[] selection) {
            HashSet<Object> map = null;
            if (selection != null && selection.length > 1) {
                map = new HashSet<Object>(selection.length);
            }
            int count = 0;
            for (int i = 0; i < selection.length; ++i) {
                try {
                    if (!(selection[i] instanceof GetterSetterEntry)) continue;
                    Object key = selection[i];
                    IField getsetField = ((GetterSetterEntry)selection[i]).fField;
                    if (((GetterSetterEntry)selection[i]).fGetterEntry ? !map.add(GetterSetterUtil.getGetterName(getsetField, null)) : !map.add(key = AddGetterSetterAction.createSignatureKey(GetterSetterUtil.getSetterName(getsetField, null), getsetField))) {
                        return new StatusInfo(2, ActionMessages.getString("AddGetterSetterAction.error.duplicate_methods"));
                    }
                    ++count;
                    continue;
                }
                catch (JavaModelException e) {
                    // empty catch block
                }
            }
            if (count == 0) {
                return new StatusInfo(4, "");
            }
            String message = ActionMessages.getFormattedString("AddGetterSetterAction.methods_selected", new Object[]{String.valueOf(count), String.valueOf(fEntries)});
            return new StatusInfo(1, message);
        }
    }
}

