/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;

public class TempOccurrenceAnalyzer
extends ASTVisitor {
    private Set fReferenceNodes;
    private Set fJavadocNodes;
    private VariableDeclaration fTempDeclaration;
    private IBinding fTempBinding;
    private boolean fAnalyzeJavadoc;
    private boolean fIsInJavadoc;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$CompilationUnit;

    public TempOccurrenceAnalyzer(VariableDeclaration tempDeclaration, boolean analyzeJavadoc) {
        Assert.isNotNull(tempDeclaration);
        this.fReferenceNodes = new HashSet();
        this.fJavadocNodes = new HashSet();
        this.fAnalyzeJavadoc = analyzeJavadoc;
        this.fTempDeclaration = tempDeclaration;
        this.fTempBinding = tempDeclaration.resolveBinding();
        this.fIsInJavadoc = false;
    }

    public void perform() {
        ASTNode cuNode = ASTNodes.getParent((ASTNode)this.fTempDeclaration, class$org$eclipse$jdt$core$dom$CompilationUnit == null ? (class$org$eclipse$jdt$core$dom$CompilationUnit = TempOccurrenceAnalyzer.class$("org.eclipse.jdt.core.dom.CompilationUnit")) : class$org$eclipse$jdt$core$dom$CompilationUnit);
        cuNode.accept((ASTVisitor)this);
    }

    public int[] getReferenceOffsets() {
        int[] offsets = new int[this.fReferenceNodes.size()];
        this.addOffsets(offsets, 0, this.fReferenceNodes);
        return offsets;
    }

    public int[] getReferenceAndJavadocOffsets() {
        int[] offsets = new int[this.fReferenceNodes.size() + this.fJavadocNodes.size()];
        this.addOffsets(offsets, 0, this.fReferenceNodes);
        this.addOffsets(offsets, this.fReferenceNodes.size(), this.fJavadocNodes);
        return offsets;
    }

    private void addOffsets(int[] offsets, int start, Set nodeSet) {
        int i = start;
        Iterator iter = nodeSet.iterator();
        while (iter.hasNext()) {
            ASTNode node = (ASTNode)iter.next();
            offsets[i] = node.getStartPosition();
            ++i;
        }
    }

    public SimpleName[] getReferenceNodes() {
        return this.fReferenceNodes.toArray(new SimpleName[this.fReferenceNodes.size()]);
    }

    public SimpleName[] getJavadocNodes() {
        return this.fJavadocNodes.toArray(new SimpleName[this.fJavadocNodes.size()]);
    }

    public SimpleName[] getReferenceAndDeclarationNodes() {
        SimpleName[] nodes = this.fReferenceNodes.toArray(new SimpleName[this.fReferenceNodes.size() + 1]);
        nodes[this.fReferenceNodes.size()] = this.fTempDeclaration.getName();
        return nodes;
    }

    public boolean visit(Javadoc node) {
        if (this.fAnalyzeJavadoc) {
            this.fIsInJavadoc = true;
        }
        return this.fAnalyzeJavadoc;
    }

    public void endVisit(Javadoc node) {
        this.fIsInJavadoc = false;
    }

    public boolean visit(SimpleName node) {
        if (node.getParent() instanceof VariableDeclaration && ((VariableDeclaration)node.getParent()).getName() == node) {
            return true;
        }
        if (this.fTempBinding != null && this.fTempBinding == node.resolveBinding()) {
            if (this.fIsInJavadoc) {
                this.fJavadocNodes.add(node);
            } else {
                this.fReferenceNodes.add(node);
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

