/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.KeyedElement;
import org.eclipse.osgi.framework.internal.core.KeyedHashSet;
import org.eclipse.osgi.framework.internal.core.PackageAdminImpl;
import org.eclipse.osgi.service.resolver.Version;

public class BundleRepository {
    private ArrayList bundlesByInstallOrder;
    private KeyedHashSet bundlesById;
    private HashMap bundlesBySymbolicName;
    private PackageAdminImpl packageAdmin;

    public BundleRepository(int initialCapacity, PackageAdminImpl packageAdmin) {
        this.bundlesByInstallOrder = new ArrayList(initialCapacity);
        this.bundlesById = new KeyedHashSet(initialCapacity, true);
        this.bundlesBySymbolicName = new HashMap(initialCapacity);
        this.packageAdmin = packageAdmin;
    }

    public List getBundles() {
        return this.bundlesByInstallOrder;
    }

    public AbstractBundle getBundle(long bundleId) {
        Long key = new Long(bundleId);
        return (AbstractBundle)this.bundlesById.getByKey(key);
    }

    public AbstractBundle[] getBundles(String symbolicName) {
        return (AbstractBundle[])this.bundlesBySymbolicName.get(symbolicName);
    }

    public AbstractBundle getBundle(String symbolicName, String version) {
        AbstractBundle[] bundles = (AbstractBundle[])this.bundlesBySymbolicName.get(symbolicName);
        if (bundles != null) {
            Version ver = new Version(version);
            if (bundles.length > 0) {
                for (int i = 0; i < bundles.length; ++i) {
                    if (!bundles[i].getVersion().equals((Object)ver)) continue;
                    return bundles[i];
                }
            }
        }
        return null;
    }

    public void add(AbstractBundle bundle) {
        this.bundlesByInstallOrder.add(bundle);
        this.bundlesById.add(bundle);
        String symbolicName = bundle.getSymbolicName();
        if (symbolicName != null) {
            AbstractBundle[] bundles = (AbstractBundle[])this.bundlesBySymbolicName.get(symbolicName);
            if (bundles == null) {
                bundles = new AbstractBundle[]{bundle};
                this.bundlesBySymbolicName.put(symbolicName, bundles);
                return;
            }
            ArrayList<AbstractBundle> list = new ArrayList<AbstractBundle>(bundles.length + 1);
            Version newVersion = bundle.getVersion();
            boolean added = false;
            for (int i = 0; i < bundles.length; ++i) {
                AbstractBundle oldBundle = bundles[i];
                Version oldVersion = oldBundle.getVersion();
                if (!added && newVersion.matchGreaterOrEqualTo(oldVersion)) {
                    added = true;
                    list.add(bundle);
                }
                list.add(oldBundle);
            }
            if (!added) {
                list.add(bundle);
            }
            bundles = new AbstractBundle[list.size()];
            list.toArray(bundles);
            this.bundlesBySymbolicName.put(symbolicName, bundles);
        }
    }

    public boolean remove(AbstractBundle bundle) {
        boolean found = this.bundlesById.remove(bundle);
        if (!found) {
            return false;
        }
        this.bundlesByInstallOrder.remove(bundle);
        String symbolicName = bundle.getSymbolicName();
        if (symbolicName == null) {
            return true;
        }
        AbstractBundle[] bundles = (AbstractBundle[])this.bundlesBySymbolicName.get(symbolicName);
        if (bundles == null) {
            return true;
        }
        int numRemoved = 0;
        for (int i = 0; i < bundles.length; ++i) {
            if (bundle != bundles[i]) continue;
            ++numRemoved;
            bundles[i] = null;
        }
        if (numRemoved > 0) {
            if (bundles.length - numRemoved <= 0) {
                this.bundlesBySymbolicName.remove(symbolicName);
            } else {
                AbstractBundle[] newBundles = new AbstractBundle[bundles.length - numRemoved];
                int indexCnt = 0;
                for (int i = 0; i < bundles.length; ++i) {
                    if (bundles[i] == null) continue;
                    newBundles[indexCnt] = bundles[i];
                    ++indexCnt;
                }
                this.bundlesBySymbolicName.put(symbolicName, newBundles);
            }
        }
        return true;
    }

    public void removeAllBundles() {
        this.bundlesByInstallOrder.clear();
        this.bundlesById = new KeyedHashSet();
        this.bundlesBySymbolicName.clear();
    }

    public void markDependancies() {
        KeyedElement[] elements = this.bundlesById.elements();
        for (int i = 0; i < elements.length; ++i) {
            if (!(elements[i] instanceof BundleHost)) continue;
            ((BundleHost)elements[i]).getLoaderProxy().markDependencies();
        }
    }

    public void unMarkDependancies(BundleLoaderProxy user) {
        KeyedElement[] elements = this.bundlesById.elements();
        for (int i = 0; i < elements.length; ++i) {
            if (!(elements[i] instanceof BundleHost)) continue;
            BundleLoaderProxy loaderProxy = ((BundleHost)elements[i]).getLoaderProxy();
            loaderProxy.unMarkUsed(user);
        }
        int size = this.packageAdmin.removalPending.size();
        for (int i = 0; i < size; ++i) {
            BundleLoaderProxy loaderProxy = (BundleLoaderProxy)this.packageAdmin.removalPending.elementAt(i);
            loaderProxy.unMarkUsed(user);
        }
        user.markedUsedDependencies = false;
    }
}

