/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.ConstructorPattern;
import org.eclipse.jdt.internal.core.search.matching.FieldPattern;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.eclipse.jdt.internal.core.search.matching.OrPattern;
import org.eclipse.jdt.internal.core.search.matching.PatternLocator;
import org.eclipse.jdt.internal.core.search.matching.QualifiedTypeDeclarationPattern;
import org.eclipse.jdt.internal.core.search.matching.SuperTypeReferencePattern;
import org.eclipse.jdt.internal.core.search.matching.TypeDeclarationPattern;

public class ClassFileMatchLocator
implements IIndexConstants {
    public static char[] convertClassFileFormat(char[] name) {
        int l = name.length;
        for (int i = 0; i < l; ++i) {
            if (name[i] != '/') continue;
            char[] newName = (char[])name.clone();
            CharOperation.replace(newName, '/', '.');
            return newName;
        }
        return name;
    }

    boolean checkDeclaringType(IBinaryType enclosingBinaryType, char[] simpleName, char[] qualification, boolean isCaseSensitive) {
        if (simpleName == null && qualification == null) {
            return true;
        }
        if (enclosingBinaryType == null) {
            return true;
        }
        char[] declaringTypeName = ClassFileMatchLocator.convertClassFileFormat(enclosingBinaryType.getName());
        return this.checkTypeName(simpleName, qualification, declaringTypeName, isCaseSensitive);
    }

    boolean checkParameters(char[] methodDescriptor, char[][] parameterSimpleNames, char[][] parameterQualifications, boolean isCaseSensitive) {
        int parameterCount = parameterSimpleNames.length;
        char[][] arguments = Signature.getParameterTypes(methodDescriptor);
        if (parameterCount != arguments.length) {
            return false;
        }
        for (int i = 0; i < parameterCount; ++i) {
            if (this.checkTypeName(parameterSimpleNames[i], parameterQualifications[i], Signature.toCharArray(arguments[i]), isCaseSensitive)) continue;
            return false;
        }
        return true;
    }

    boolean checkTypeName(char[] simpleName, char[] qualification, char[] fullyQualifiedTypeName, boolean isCaseSensitive) {
        char[] wildcardPattern = PatternLocator.qualifiedPattern(simpleName, qualification);
        if (wildcardPattern == null) {
            return true;
        }
        return CharOperation.match(wildcardPattern, fullyQualifiedTypeName, isCaseSensitive);
    }

    public void locateMatches(MatchLocator locator, ClassFile classFile, IBinaryType info) throws CoreException {
        IBinaryField[] fields;
        IBinaryMethod[] methods;
        SearchPattern pattern = locator.pattern;
        BinaryType binaryType = (BinaryType)classFile.getType();
        if (this.matchBinary(pattern, info, null)) {
            locator.reportBinaryMemberDeclaration(null, binaryType, info, 0);
        }
        int accuracy = 0;
        if (pattern.mustResolve) {
            try {
                BinaryTypeBinding binding = locator.cacheBinaryType(binaryType);
                if (binding != null) {
                    if (!locator.typeInHierarchy(binding)) {
                        return;
                    }
                    MethodBinding[] methods2 = binding.methods();
                    int l = methods2.length;
                    for (int i = 0; i < l; ++i) {
                        MethodBinding method = methods2[i];
                        if (locator.patternLocator.resolveLevel(method) != 3) continue;
                        IMethod methodHandle = binaryType.getMethod(new String(method.isConstructor() ? binding.compoundName[binding.compoundName.length - 1] : method.selector), CharOperation.toStrings(Signature.getParameterTypes(ClassFileMatchLocator.convertClassFileFormat(method.signature()))));
                        locator.reportBinaryMemberDeclaration(null, methodHandle, info, 0);
                    }
                    FieldBinding[] fields2 = binding.fields();
                    int l2 = fields2.length;
                    for (int i = 0; i < l2; ++i) {
                        FieldBinding field = fields2[i];
                        if (locator.patternLocator.resolveLevel(field) != 3) continue;
                        IField fieldHandle = binaryType.getField(new String(field.name));
                        locator.reportBinaryMemberDeclaration(null, fieldHandle, info, 0);
                    }
                    return;
                }
            }
            catch (AbortCompilation e) {
                // empty catch block
            }
            accuracy = 1;
        }
        if ((methods = info.getMethods()) != null) {
            int l = methods.length;
            for (int i = 0; i < l; ++i) {
                IBinaryMethod method = methods[i];
                if (!this.matchBinary(pattern, method, info)) continue;
                IMethod methodHandle = binaryType.getMethod(new String(method.isConstructor() ? info.getName() : method.getSelector()), CharOperation.toStrings(Signature.getParameterTypes(ClassFileMatchLocator.convertClassFileFormat(method.getMethodDescriptor()))));
                locator.reportBinaryMemberDeclaration(null, methodHandle, info, accuracy);
            }
        }
        if ((fields = info.getFields()) != null) {
            int l = fields.length;
            for (int i = 0; i < l; ++i) {
                IBinaryField field = fields[i];
                if (!this.matchBinary(pattern, field, info)) continue;
                IField fieldHandle = binaryType.getField(new String(field.getName()));
                locator.reportBinaryMemberDeclaration(null, fieldHandle, info, accuracy);
            }
        }
    }

    boolean matchBinary(SearchPattern pattern, Object binaryInfo, IBinaryType enclosingBinaryType) {
        switch (pattern.kind) {
            case 32: {
                return this.matchConstructor((ConstructorPattern)pattern, binaryInfo, enclosingBinaryType);
            }
            case 64: {
                return this.matchField((FieldPattern)pattern, binaryInfo, enclosingBinaryType);
            }
            case 128: {
                return this.matchMethod((MethodPattern)pattern, binaryInfo, enclosingBinaryType);
            }
            case 16: {
                return this.matchSuperTypeReference((SuperTypeReferencePattern)pattern, binaryInfo, enclosingBinaryType);
            }
            case 8: {
                return this.matchTypeDeclaration((TypeDeclarationPattern)pattern, binaryInfo, enclosingBinaryType);
            }
            case 256: {
                SearchPattern[] patterns = ((OrPattern)pattern).patterns;
                int length = patterns.length;
                for (int i = 0; i < length; ++i) {
                    if (!this.matchBinary(patterns[i], binaryInfo, enclosingBinaryType)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    boolean matchConstructor(ConstructorPattern pattern, Object binaryInfo, IBinaryType enclosingBinaryType) {
        char[] methodDescriptor;
        if (!pattern.findDeclarations) {
            return false;
        }
        if (!(binaryInfo instanceof IBinaryMethod)) {
            return false;
        }
        IBinaryMethod method = (IBinaryMethod)binaryInfo;
        if (!method.isConstructor()) {
            return false;
        }
        if (!this.checkDeclaringType(enclosingBinaryType, pattern.declaringSimpleName, pattern.declaringQualification, pattern.isCaseSensitive())) {
            return false;
        }
        return pattern.parameterSimpleNames == null || this.checkParameters(methodDescriptor = ClassFileMatchLocator.convertClassFileFormat(method.getMethodDescriptor()), pattern.parameterSimpleNames, pattern.parameterQualifications, pattern.isCaseSensitive());
    }

    boolean matchField(FieldPattern pattern, Object binaryInfo, IBinaryType enclosingBinaryType) {
        if (!pattern.findDeclarations) {
            return false;
        }
        if (!(binaryInfo instanceof IBinaryField)) {
            return false;
        }
        IBinaryField field = (IBinaryField)binaryInfo;
        if (!pattern.matchesName(pattern.name, field.getName())) {
            return false;
        }
        if (!this.checkDeclaringType(enclosingBinaryType, pattern.declaringSimpleName, pattern.declaringQualification, pattern.isCaseSensitive())) {
            return false;
        }
        char[] fieldTypeSignature = Signature.toCharArray(ClassFileMatchLocator.convertClassFileFormat(field.getTypeName()));
        return this.checkTypeName(pattern.typeSimpleName, pattern.typeQualification, fieldTypeSignature, pattern.isCaseSensitive());
    }

    boolean matchMethod(MethodPattern pattern, Object binaryInfo, IBinaryType enclosingBinaryType) {
        boolean checkParameters;
        if (!pattern.findDeclarations) {
            return false;
        }
        if (!(binaryInfo instanceof IBinaryMethod)) {
            return false;
        }
        IBinaryMethod method = (IBinaryMethod)binaryInfo;
        if (!pattern.matchesName(pattern.selector, method.getSelector())) {
            return false;
        }
        if (!this.checkDeclaringType(enclosingBinaryType, pattern.declaringSimpleName, pattern.declaringQualification, pattern.isCaseSensitive())) {
            return false;
        }
        boolean checkReturnType = pattern.declaringSimpleName == null && (pattern.returnSimpleName != null || pattern.returnQualification != null);
        boolean bl = checkParameters = pattern.parameterSimpleNames != null;
        if (checkReturnType || checkParameters) {
            char[] returnTypeSignature;
            char[] methodDescriptor = ClassFileMatchLocator.convertClassFileFormat(method.getMethodDescriptor());
            if (checkReturnType && !this.checkTypeName(pattern.returnSimpleName, pattern.returnQualification, returnTypeSignature = Signature.toCharArray(Signature.getReturnType(methodDescriptor)), pattern.isCaseSensitive())) {
                return false;
            }
            if (checkParameters && !this.checkParameters(methodDescriptor, pattern.parameterSimpleNames, pattern.parameterQualifications, pattern.isCaseSensitive())) {
                return false;
            }
        }
        return true;
    }

    boolean matchSuperTypeReference(SuperTypeReferencePattern pattern, Object binaryInfo, IBinaryType enclosingBinaryType) {
        char[] superclassName;
        char[] vmName;
        if (!(binaryInfo instanceof IBinaryType)) {
            return false;
        }
        IBinaryType type = (IBinaryType)binaryInfo;
        if (!pattern.checkOnlySuperinterfaces && (vmName = type.getSuperclassName()) != null && this.checkTypeName(pattern.superSimpleName, pattern.superQualification, superclassName = ClassFileMatchLocator.convertClassFileFormat(vmName), pattern.isCaseSensitive())) {
            return true;
        }
        char[][] superInterfaces = type.getInterfaceNames();
        if (superInterfaces != null) {
            int max = superInterfaces.length;
            for (int i = 0; i < max; ++i) {
                char[] superInterfaceName = ClassFileMatchLocator.convertClassFileFormat(superInterfaces[i]);
                if (!this.checkTypeName(pattern.superSimpleName, pattern.superQualification, superInterfaceName, pattern.isCaseSensitive())) continue;
                return true;
            }
        }
        return false;
    }

    boolean matchTypeDeclaration(TypeDeclarationPattern pattern, Object binaryInfo, IBinaryType enclosingBinaryType) {
        if (!(binaryInfo instanceof IBinaryType)) {
            return false;
        }
        IBinaryType type = (IBinaryType)binaryInfo;
        char[] fullyQualifiedTypeName = ClassFileMatchLocator.convertClassFileFormat(type.getName());
        if (pattern.enclosingTypeNames == null || pattern instanceof QualifiedTypeDeclarationPattern) {
            if (!this.checkTypeName(pattern.simpleName, pattern.pkg, fullyQualifiedTypeName, pattern.isCaseSensitive())) {
                return false;
            }
        } else {
            char[] patternString;
            char[] enclosingTypeName = CharOperation.concatWith(pattern.enclosingTypeNames, '.');
            char[] cArray = patternString = pattern.pkg == null ? enclosingTypeName : CharOperation.concat(pattern.pkg, enclosingTypeName, '.');
            if (!this.checkTypeName(pattern.simpleName, patternString, fullyQualifiedTypeName, pattern.isCaseSensitive())) {
                return false;
            }
        }
        switch (pattern.classOrInterface) {
            case 'C': {
                return !type.isInterface();
            }
            case 'I': {
                return type.isInterface();
            }
        }
        return true;
    }
}

