/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.pluginconversion.PluginConversionException;
import org.eclipse.osgi.service.pluginconversion.PluginConverter;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.Version;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.IBuildPropertiesConstants;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.builder.AbstractBuildScriptGenerator;
import org.eclipse.pde.internal.build.site.QualifierReplacer;
import org.osgi.framework.BundleException;

public class PDEState
implements IPDEBuildConstants,
IBuildPropertiesConstants {
    private StateObjectFactory factory = Platform.getPlatformAdmin().getFactory();
    protected State state = this.factory.createState();
    private long id;
    private Properties repositoryVersions;
    private HashMap bundleClasspaths;
    static /* synthetic */ Class class$org$eclipse$osgi$service$pluginconversion$PluginConverter;

    protected long getNextId() {
        return ++this.id;
    }

    public PDEState() {
        this.state.setResolver(Platform.getPlatformAdmin().getResolver());
        this.id = 0L;
        this.bundleClasspaths = new HashMap();
        this.loadPluginVersionFile();
    }

    public StateObjectFactory getFactory() {
        return this.factory;
    }

    public void addBundleDescription(BundleDescription toAdd) {
        this.state.addBundle(toAdd);
    }

    private PluginConverter acquirePluginConverter() throws Exception {
        return (PluginConverter)BundleHelper.getDefault().acquireService((class$org$eclipse$osgi$service$pluginconversion$PluginConverter == null ? (class$org$eclipse$osgi$service$pluginconversion$PluginConverter = PDEState.class$("org.eclipse.osgi.service.pluginconversion.PluginConverter")) : class$org$eclipse$osgi$service$pluginconversion$PluginConverter).getName());
    }

    public boolean addBundle(Dictionary enhancedManifest, File bundleLocation) {
        this.updateVersionNumber(enhancedManifest);
        try {
            BundleDescription descriptor = this.factory.createBundleDescription(enhancedManifest, bundleLocation.getAbsolutePath(), this.getNextId());
            this.bundleClasspaths.put(new Long(descriptor.getBundleId()), this.getClasspath(enhancedManifest));
            this.state.addBundle(descriptor);
        }
        catch (BundleException e) {
            Status status = new Status(2, "org.eclipse.pde.build", 15, Policy.bind("exception.stateAddition", (String)enhancedManifest.get("Bundle-Name")), (Throwable)e);
            BundleHelper.getDefault().getLog().log((IStatus)status);
            return false;
        }
        return true;
    }

    private String[] getClasspath(Dictionary manifest) {
        String fullClasspath = (String)manifest.get("Bundle-ClassPath");
        String[] result = new String[]{};
        try {
            if (fullClasspath != null) {
                ManifestElement[] classpathEntries = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)fullClasspath);
                result = new String[classpathEntries.length];
                for (int i = 0; i < classpathEntries.length; ++i) {
                    result[i] = classpathEntries[i].getValue();
                }
            }
        }
        catch (BundleException e) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPluginVersionFile() {
        this.repositoryVersions = new Properties();
        try {
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(AbstractScriptGenerator.getWorkingDirectory() + '/' + "pluginVersions.properties"));
            try {
                this.repositoryVersions.load(input);
            }
            finally {
                ((InputStream)input).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean addBundle(File bundleLocation) {
        Dictionary manifest = this.loadManifest(bundleLocation);
        if (manifest == null) {
            return false;
        }
        try {
            String symbolicHeader = (String)manifest.get("Bundle-SymbolicName");
            if (symbolicHeader != null && ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicHeader)[0].getValue().equals("org.eclipse.osgi")) {
                manifest.put("Bundle-ClassPath", this.findOSGiJars(bundleLocation));
            }
            this.hasQualifier(bundleLocation, manifest);
        }
        catch (BundleException bundleException) {
            // empty catch block
        }
        return this.addBundle(manifest, bundleLocation);
    }

    private String findOSGiJars(File bundleLocation) {
        String eclipseProperies = "eclipse.properties";
        InputStream manifestStream = null;
        try {
            URL manifestLocation = null;
            if (bundleLocation.getName().endsWith("jar")) {
                manifestLocation = new URL("jar:file:" + bundleLocation + "!/" + eclipseProperies);
                manifestStream = manifestLocation.openStream();
            } else {
                manifestStream = new FileInputStream(new File(bundleLocation, eclipseProperies));
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        Properties properties = new Properties();
        try {
            properties.load(manifestStream);
            manifestStream.close();
        }
        catch (IOException e1) {
            // empty catch block
        }
        String osgiPath = properties.getProperty("osgi.frameworkClassPath");
        if (osgiPath == null) {
            osgiPath = "core.jar, console.jar, osgi.jar, resolver.jar, defaultAdaptor.jar, eclipseAdaptor.jar";
        }
        return osgiPath;
    }

    private void updateVersionNumber(Dictionary manifest) {
        String newVersion = QualifierReplacer.replaceQualifierInVersion((String)manifest.get("Bundle-Version"), (String)manifest.get("Bundle-SymbolicName"), (String)manifest.get("qualifier"), this.repositoryVersions);
        if (newVersion != null) {
            manifest.put("Bundle-Version", newVersion);
        }
    }

    private void hasQualifier(File bundleLocation, Dictionary manifest) throws BundleException {
        ManifestElement[] versionInfo = ManifestElement.parseHeader((String)"Bundle-Version", (String)((String)manifest.get("Bundle-Version")));
        if (versionInfo != null && versionInfo[0].getValue().endsWith("qualifier")) {
            try {
                String qualifierInfo = AbstractScriptGenerator.readProperties(bundleLocation.getAbsolutePath(), "build.properties", 1).getProperty("qualifier");
                manifest.put("qualifier", qualifierInfo);
            }
            catch (CoreException e1) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dictionary loadManifest(File bundleLocation) {
        InputStream manifestStream = null;
        try {
            URL manifestLocation = null;
            if (bundleLocation.getName().endsWith("jar")) {
                manifestLocation = new URL("jar:file:" + bundleLocation + "!/" + "META-INF/MANIFEST.MF");
                manifestStream = manifestLocation.openStream();
            } else {
                manifestStream = new FileInputStream(new File(bundleLocation, "META-INF/MANIFEST.MF"));
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (manifestStream == null) {
            try {
                PluginConverter converter = this.acquirePluginConverter();
                return converter.convertManifest(bundleLocation, false, AbstractBuildScriptGenerator.isBuildingOSGi() ? null : "2.1", false);
            }
            catch (PluginConversionException convertException) {
                if (bundleLocation.getName().equals("feature.xml")) {
                    return null;
                }
                Status status = new Status(2, "org.eclipse.pde.build", 0, Policy.bind("exception.errorConverting", bundleLocation.getAbsolutePath()), (Throwable)convertException);
                BundleHelper.getDefault().getLog().log((IStatus)status);
                return null;
            }
            catch (Exception serviceException) {
                Status status = new Status(2, "org.eclipse.pde.build", 0, Policy.bind("exception.cannotAcquireService", "Plugin converter"), (Throwable)serviceException);
                BundleHelper.getDefault().getLog().log((IStatus)status);
                return null;
            }
        }
        try {
            Manifest m = new Manifest(manifestStream);
            Properties properties = this.manifestToProperties(m.getMainAttributes());
            String classpath = (String)properties.get("Bundle-ClassPath");
            if (classpath == null) {
                properties.put("Bundle-ClassPath", ".");
            }
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            Dictionary dictionary = null;
            return dictionary;
        }
        finally {
            try {
                manifestStream.close();
            }
            catch (IOException e1) {}
        }
    }

    private Properties manifestToProperties(Attributes d) {
        Iterator<Object> iter = d.keySet().iterator();
        Properties result = new Properties();
        while (iter.hasNext()) {
            Attributes.Name key = (Attributes.Name)iter.next();
            result.put(key.toString(), d.get(key));
        }
        return result;
    }

    public void addBundles(Collection bundles) {
        Iterator iter = bundles.iterator();
        while (iter.hasNext()) {
            File bundle = (File)iter.next();
            this.addBundle(bundle);
        }
    }

    public void resolveState() {
        this.state.resolve(false);
    }

    public State getState() {
        return this.state;
    }

    public BundleDescription[] getDependentBundles(String bundleId, Version version) {
        BundleDescription root = this.state.getBundle(bundleId, version);
        return PDEState.getDependentBundles(root);
    }

    public static BundleDescription[] getImportedBundles(BundleDescription root) {
        if (root == null) {
            return new BundleDescription[0];
        }
        PackageSpecification[] packages = root.getPackages();
        ArrayList<BundleDescription> resolvedImported = new ArrayList<BundleDescription>(packages.length);
        for (int i = 0; i < packages.length; ++i) {
            if (packages[i].isExported() || !packages[i].isResolved() || resolvedImported.contains(packages[i].getSupplier())) continue;
            resolvedImported.add(packages[i].getSupplier());
        }
        BundleDescription[] result = new BundleDescription[resolvedImported.size()];
        return resolvedImported.toArray(result);
    }

    public static BundleDescription[] getRequiredBundles(BundleDescription root) {
        if (root == null) {
            return new BundleDescription[0];
        }
        BundleSpecification[] required = root.getRequiredBundles();
        ArrayList<BundleDescription> resolvedRequired = new ArrayList<BundleDescription>(required.length);
        for (int i = 0; i < required.length; ++i) {
            if (!required[i].isResolved() || resolvedRequired.contains(required[i].getSupplier())) continue;
            resolvedRequired.add(required[i].getSupplier());
        }
        BundleDescription[] result = new BundleDescription[resolvedRequired.size()];
        return resolvedRequired.toArray(result);
    }

    public BundleDescription getResolvedBundle(String bundleId, String version) {
        if ("0.0.0".equals(version) || version == null) {
            return this.getResolvedBundle(bundleId);
        }
        BundleDescription description = this.getState().getBundle(bundleId, new Version(version));
        if (description != null && description.isResolved()) {
            return description;
        }
        int qualifierIdx = -1;
        qualifierIdx = version.indexOf(".qualifier");
        if (qualifierIdx != -1) {
            BundleDescription[] bundles = this.getState().getBundles(bundleId);
            Version versionToMatch = new Version(version.substring(0, qualifierIdx));
            for (int i = 0; i < bundles.length; ++i) {
                if (!bundles[i].getVersion().matchMinor(versionToMatch)) continue;
                return bundles[i];
            }
        }
        return null;
    }

    public BundleDescription getResolvedBundle(String bundleId) {
        BundleDescription[] description = this.getState().getBundles(bundleId);
        if (description == null) {
            return null;
        }
        for (int i = 0; i < description.length; ++i) {
            if (!description[i].isResolved()) continue;
            return description[i];
        }
        return null;
    }

    public static BundleDescription[] getDependentBundles(BundleDescription root) {
        BundleDescription[] imported = PDEState.getImportedBundles(root);
        BundleDescription[] required = PDEState.getRequiredBundles(root);
        BundleDescription[] dependents = new BundleDescription[imported.length + required.length];
        System.arraycopy(imported, 0, dependents, 0, imported.length);
        System.arraycopy(required, 0, dependents, imported.length, required.length);
        return dependents;
    }

    public static BundleDescription[] getDependentBundlesWithFragments(BundleDescription root) {
        BundleDescription[] imported = PDEState.getImportedBundles(root);
        BundleDescription[] importedByFragments = PDEState.getImportedByFragments(root);
        BundleDescription[] required = PDEState.getRequiredBundles(root);
        BundleDescription[] requiredByFragments = PDEState.getRequiredByFragments(root);
        BundleDescription[] dependents = new BundleDescription[imported.length + importedByFragments.length + required.length + requiredByFragments.length];
        System.arraycopy(imported, 0, dependents, 0, imported.length);
        System.arraycopy(importedByFragments, 0, dependents, imported.length, importedByFragments.length);
        System.arraycopy(required, 0, dependents, imported.length + importedByFragments.length, required.length);
        System.arraycopy(requiredByFragments, 0, dependents, imported.length + importedByFragments.length + required.length, requiredByFragments.length);
        return dependents;
    }

    public static BundleDescription[] getImportedByFragments(BundleDescription root) {
        BundleDescription[] fragments = root.getFragments();
        ArrayList importedByFragments = new ArrayList();
        for (int i = 0; i < fragments.length; ++i) {
            if (!fragments[i].isResolved()) continue;
            PDEState.merge(importedByFragments, PDEState.getImportedBundles(fragments[i]));
        }
        BundleDescription[] result = new BundleDescription[importedByFragments.size()];
        return importedByFragments.toArray(result);
    }

    public static BundleDescription[] getRequiredByFragments(BundleDescription root) {
        BundleDescription[] fragments = root.getFragments();
        ArrayList importedByFragments = new ArrayList();
        for (int i = 0; i < fragments.length; ++i) {
            if (!fragments[i].isResolved()) continue;
            PDEState.merge(importedByFragments, PDEState.getRequiredBundles(fragments[i]));
        }
        BundleDescription[] result = new BundleDescription[importedByFragments.size()];
        return importedByFragments.toArray(result);
    }

    public static void merge(List source, BundleDescription[] toAdd) {
        for (int i = 0; i < toAdd.length; ++i) {
            if (source.contains(toAdd[i])) continue;
            source.add(toAdd[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadPropertyFileIn(Map toMerge, File location) {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)toMerge);
        try {
            BufferedInputStream propertyStream = new BufferedInputStream(new FileInputStream(new File(location, "build.properties")));
            try {
                result.load(propertyStream);
            }
            finally {
                ((InputStream)propertyStream).close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public HashMap getExtraData() {
        return this.bundleClasspaths;
    }

    public List getSortedBundles() {
        return Utils.computePrerequisiteOrder(Arrays.asList(this.getState().getResolvedBundles()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

