/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.ant;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.pde.internal.build.ant.FileSet;
import org.eclipse.pde.internal.build.ant.ITask;

public class AntScript {
    protected OutputStream out;
    protected PrintWriter output;
    protected final String XML_PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    protected int indent = 0;

    public AntScript(OutputStream out) throws IOException {
        this.out = out;
        this.output = new PrintWriter(new OutputStreamWriter(out, "UTF8"));
        this.output.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }

    public void close() {
        this.output.flush();
        this.output.close();
        try {
            this.out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void printAntCallTask(String target, String inheritAll, Map params) {
        this.printTab();
        this.output.print("<antcall");
        this.printAttribute("target", target, true);
        this.printAttribute("inheritAll", inheritAll, false);
        if (params == null) {
            this.output.println("/>");
        } else {
            this.output.println(">");
            ++this.indent;
            Set entries = params.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                this.printParam((String)entry.getKey(), (String)entry.getValue());
            }
            --this.indent;
            this.printTab();
            this.output.println("</antcall>");
        }
    }

    public void printJarTask(String jarFile, String basedir) {
        this.printTab();
        this.output.print("<jar");
        this.printAttribute("jarfile", jarFile, true);
        this.printAttribute("basedir", basedir, false);
        this.output.println("/>");
    }

    public void printAvailableTask(String property, String file) {
        this.printTab();
        this.output.print("<available");
        this.printAttribute("property", property, true);
        this.printAttribute("file", file, false);
        this.output.println("/>");
    }

    public void printAntTask(String antfile, String dir, String target, String outputParam, String inheritAll, Map properties) {
        this.printTab();
        this.output.print("<ant");
        this.printAttribute("antfile", antfile, false);
        this.printAttribute("dir", dir, false);
        this.printAttribute("target", target, false);
        this.printAttribute("output", outputParam, false);
        this.printAttribute("inheritAll", inheritAll, false);
        if (properties == null) {
            this.output.println("/>");
        } else {
            this.output.println(">");
            ++this.indent;
            Set entries = properties.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                this.printProperty((String)entry.getKey(), (String)entry.getValue());
            }
            --this.indent;
            this.printTab();
            this.output.println("</ant>");
        }
    }

    public void printZipTask(String zipfile, String basedir, boolean filesOnly, boolean update, FileSet[] fileSets) {
        this.printTab();
        this.output.print("<zip");
        this.printAttribute("zipfile", zipfile, true);
        this.printAttribute("basedir", basedir, false);
        this.printAttribute("filesonly", filesOnly ? "true" : "false", true);
        this.printAttribute("whenempty", "skip", true);
        this.printAttribute("update", update ? "true" : "false", true);
        if (fileSets == null) {
            this.output.println("/>");
        } else {
            this.output.println(">");
            ++this.indent;
            for (int i = 0; i < fileSets.length; ++i) {
                if (fileSets[i] == null) continue;
                fileSets[i].print(this);
            }
            --this.indent;
            this.printTab();
            this.output.println("</zip>");
        }
    }

    public void printTarTask(String zipfile, String basedir, boolean filesOnly, boolean update, FileSet[] fileSets) {
        this.printTab();
        this.output.print("<tar");
        this.printAttribute("destfile", zipfile, true);
        this.printAttribute("basedir", basedir, false);
        this.printAttribute("compression", "gzip", true);
        if (fileSets == null) {
            this.output.println("/>");
        } else {
            this.output.println(">");
            ++this.indent;
            for (int i = 0; i < fileSets.length; ++i) {
                if (fileSets[i] == null) continue;
                fileSets[i].print(this);
            }
            --this.indent;
            this.printTab();
            this.output.println("</tar>");
        }
    }

    protected void printArg(String line) {
        this.printTab();
        this.output.print("<arg");
        this.printAttribute("line", line, false);
        this.output.println("/>");
    }

    public void printString(String string) {
        this.printTab();
        this.output.println(string);
    }

    public void printComment(String comment) {
        this.printTab();
        this.output.print("<!-- ");
        this.output.print(comment);
        this.output.println(" -->");
    }

    protected void printAttribute(String name, String value, boolean mandatory) {
        if (mandatory && value == null) {
            value = "";
        }
        if (value != null) {
            this.output.print(" ");
            this.output.print(name);
            this.output.print("=");
            this.printQuotes(value);
        }
    }

    public void printCopyTask(String file, String todir, FileSet[] fileSets, boolean failOnError) {
        this.printTab();
        this.output.print("<copy");
        this.printAttribute("file", file, false);
        this.printAttribute("todir", todir, false);
        this.printAttribute("failonerror", failOnError ? "true" : "false", true);
        if (fileSets == null) {
            this.output.println("/>");
        } else {
            this.output.println(">");
            ++this.indent;
            for (int i = 0; i < fileSets.length; ++i) {
                fileSets[i].print(this);
            }
            --this.indent;
            this.printTab();
            this.output.println("</copy>");
        }
    }

    public void printCopyFileTask(String file, String toFile, boolean overwrite) {
        this.printTab();
        this.output.print("<copy");
        this.printAttribute("file", file, false);
        this.printAttribute("tofile", toFile, false);
        this.printAttribute("overwrite", overwrite ? "true" : null, false);
        this.output.println("/>");
    }

    public void printDeleteTask(String dir, String file, FileSet[] fileSets) {
        this.printTab();
        this.output.print("<delete");
        this.printAttribute("dir", dir, false);
        this.printAttribute("file", file, false);
        if (fileSets == null) {
            this.output.println("/>");
        } else {
            this.output.println(">");
            ++this.indent;
            for (int i = 0; i < fileSets.length; ++i) {
                fileSets[i].print(this);
            }
            --this.indent;
            this.printTab();
            this.output.println("</delete>");
        }
    }

    public void printExecTask(String executable, String dir, List lineArgs, String os) {
        this.printTab();
        this.output.print("<exec");
        this.printAttribute("executable", executable, true);
        this.printAttribute("dir", dir, false);
        this.printAttribute("os", os, false);
        if (lineArgs == null || lineArgs.size() == 0) {
            this.output.println("/>");
        } else {
            this.output.println(">");
            ++this.indent;
            for (int i = 0; i < lineArgs.size(); ++i) {
                this.printArg((String)lineArgs.get(i));
            }
            --this.indent;
            this.printTab();
            this.output.println("</exec>");
        }
    }

    public void printMkdirTask(String dir) {
        this.printTab();
        this.output.print("<mkdir");
        this.printAttribute("dir", dir, false);
        this.output.println("/>");
    }

    public void printEchoTask(String message) {
        this.printTab();
        this.output.print("<echo");
        this.printAttribute("message", message, true);
        this.output.println("/>");
    }

    public void printCVSTask(String command, String cvsRoot, String dest, String module, String tag, String quiet, String passFile) {
        this.printTab();
        this.output.print("<cvs");
        this.printAttribute("command", command, false);
        this.printAttribute("cvsRoot", cvsRoot, false);
        this.printAttribute("dest", dest, false);
        this.printAttribute("package", module, false);
        this.printAttribute("tag", tag, false);
        this.printAttribute("quiet", quiet, false);
        this.printAttribute("passfile", passFile, false);
        this.output.println("/>");
    }

    public void printCVSPassTask(String cvsRoot, String password, String passFile) {
        this.printTab();
        this.output.print("<cvspass");
        this.printAttribute("cvsRoot", cvsRoot, true);
        this.printAttribute("password", password, true);
        this.printAttribute("passfile", passFile, false);
        this.output.println("/>");
    }

    protected void printParam(String name, String value) {
        this.printTab();
        this.output.print("<param");
        this.printAttribute("name", name, true);
        this.printAttribute("value", value, true);
        this.output.println("/>");
    }

    public void printProjectDeclaration(String name, String target, String basedir) {
        this.output.print("<project");
        this.printAttribute("name", name, false);
        this.printAttribute("default", target, true);
        this.printAttribute("basedir", basedir, false);
        this.output.println(">");
        ++this.indent;
    }

    public void printProjectEnd() {
        --this.indent;
        this.printEndTag("project");
    }

    public void printProperty(String name, String value) {
        this.printTab();
        this.output.print("<property");
        this.printAttribute("name", name, true);
        this.printAttribute("value", value, true);
        this.output.println("/>");
    }

    protected void printQuotes(String message) {
        this.output.print("\"");
        this.output.print(message);
        this.output.print("\"");
    }

    public void printStartTag(String tag) {
        this.printTab();
        this.output.print("<");
        this.output.print(tag);
        this.output.println(">");
    }

    public void printEndTag(String tag) {
        this.printTab();
        this.output.print("</");
        this.output.print(tag);
        this.output.println(">");
    }

    protected void printTab() {
        for (int i = 0; i < this.indent; ++i) {
            this.output.print("\t");
        }
    }

    public void println(String message) {
        this.printTab();
        this.output.println(message);
    }

    public void print(String message) {
        this.output.print(message);
    }

    public void println() {
        this.output.println();
    }

    public void print(ITask task) {
        task.print(this);
    }

    public void printTargetDeclaration(String name, String depends, String ifClause, String unlessClause, String description) {
        this.printTab();
        this.output.print("<target");
        this.printAttribute("name", name, true);
        this.printAttribute("depends", depends, false);
        this.printAttribute("if", ifClause, false);
        this.printAttribute("unless", unlessClause, false);
        this.printAttribute("description", description, false);
        this.output.println(">");
        ++this.indent;
    }

    public void printTargetEnd() {
        --this.indent;
        this.printEndTag("target");
    }

    public void printRefreshLocalTask(String resource, String depth) {
        this.printTab();
        this.output.print("<eclipse.refreshLocal");
        this.printAttribute("resource", resource, true);
        this.printAttribute("depth", depth, false);
        this.output.println("/>");
    }

    public void printChmod(String dir, String rights, String files) {
        this.printTab();
        this.output.print("<chmod perm=\"" + rights + "\" ");
        this.output.print("dir=\"" + dir + "\" ");
        this.output.print("includes=\"" + files + "\" /> ");
        this.output.println();
    }

    public void printGet(String source, String destination, String login, String password, boolean usetimestamp) {
        this.printTab();
        this.output.print("<get ");
        this.printAttribute("username", login, false);
        this.printAttribute("password", password, false);
        this.printAttribute("src", source, true);
        this.printAttribute("dest", destination, true);
        this.printAttribute("usetimestamp", usetimestamp ? "true" : null, false);
        this.output.println("/>");
    }

    public void printGZip(String source, String destination) {
        this.printTab();
        this.output.println("<gzip src=\"" + source + "\" zipfile=\"" + destination + "\"/>");
    }

    public void printConvertPathTask(String toConvert, String propertyName, boolean isEclipseResource) {
        this.printTab();
        this.output.print("<eclipse.convertPath");
        if (!isEclipseResource) {
            this.printAttribute("fileSystemPath", toConvert, true);
        } else {
            this.printAttribute("resourcePath", toConvert, true);
        }
        this.printAttribute("property", propertyName, true);
        this.output.println("/>");
    }

    public void printDirName(String property, String file) {
        this.printTab();
        this.output.print("<dirname");
        this.printAttribute("property", property, true);
        this.printAttribute("file", file, true);
        this.output.println("/>");
    }
}

