/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dnd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.ui.internal.DragCursors;
import org.eclipse.ui.internal.dnd.IDragOverListener;
import org.eclipse.ui.internal.dnd.IDropTarget;
import org.eclipse.ui.internal.dnd.SwtUtil;
import org.eclipse.ui.internal.dnd.TestDropLocation;

public class DragUtil {
    private static final String DROP_TARGET_ID = "org.eclipse.ui.internal.dnd.dropTarget";
    private static TestDropLocation forcedDropTarget = null;
    private static List defaultTargets = new ArrayList();

    public static void addDragTarget(Control control, IDragOverListener target) {
        if (control == null) {
            defaultTargets.add(target);
        } else {
            ArrayList<IDragOverListener> targetList = DragUtil.getTargetList(control);
            if (targetList == null) {
                targetList = new ArrayList<IDragOverListener>(1);
            }
            targetList.add(target);
            control.setData(DROP_TARGET_ID, targetList);
        }
    }

    private static List getTargetList(Control control) {
        List result = (List)control.getData(DROP_TARGET_ID);
        return result;
    }

    public static void removeDragTarget(Control control, IDragOverListener target) {
        if (control == null) {
            defaultTargets.remove(target);
        } else {
            List targetList = DragUtil.getTargetList(control);
            if (targetList != null) {
                targetList.remove(target);
                if (targetList.isEmpty()) {
                    control.setData(DROP_TARGET_ID, null);
                }
            }
        }
    }

    public static Rectangle getDisplayBounds(Control boundsControl) {
        Composite parent = boundsControl.getParent();
        if (parent == null) {
            return boundsControl.getBounds();
        }
        return Geometry.toDisplay((Control)parent, (Rectangle)boundsControl.getBounds());
    }

    public static boolean performDrag(Object draggedItem, Rectangle sourceBounds) {
        return DragUtil.performDrag(draggedItem, sourceBounds, Display.getDefault().getCursorLocation(), false);
    }

    public static boolean performDrag(Object draggedItem, Rectangle sourceBounds, Point initialLocation, boolean allowSnapping) {
        IDropTarget target = DragUtil.dragToTarget(draggedItem, sourceBounds, initialLocation, allowSnapping);
        if (target == null) {
            return false;
        }
        target.drop();
        return true;
    }

    public static boolean dragTo(Display display, Object draggedItem, Point finalLocation, Rectangle dragRectangle) {
        Control currentControl = SwtUtil.findControl(display, finalLocation);
        IDropTarget target = DragUtil.getDropTarget(currentControl, draggedItem, finalLocation, dragRectangle);
        if (target == null) {
            return false;
        }
        target.drop();
        return true;
    }

    public static void forceDropLocation(TestDropLocation forcedLocation) {
        forcedDropTarget = forcedLocation;
    }

    static IDropTarget dragToTarget(final Object draggedItem, final Rectangle sourceBounds, final Point initialLocation, final boolean allowSnapping) {
        Control startControl;
        final Display display = Display.getDefault();
        if (forcedDropTarget != null) {
            Point location = forcedDropTarget.getLocation();
            Control currentControl = SwtUtil.findControl(display, location);
            return DragUtil.getDropTarget(currentControl, draggedItem, location, sourceBounds);
        }
        final Tracker tracker = new Tracker(display, 0);
        tracker.setStippled(true);
        tracker.addListener(10, new Listener(){

            public void handleEvent(Event event) {
                display.syncExec(new Runnable(this, event){
                    private final /* synthetic */ Event val$event;
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$event = val$event;
                    }

                    public void run() {
                        Point location = new Point(this.val$event.x, this.val$event.y);
                        Control targetControl = 1.access$000(this.this$0).getCursorControl();
                        IDropTarget target = DragUtil.getDropTarget(targetControl, 1.access$100(this.this$0), location, 1.access$200(this.this$0).getRectangles()[0]);
                        Rectangle snapTarget = null;
                        if (target != null) {
                            snapTarget = target.getSnapRectangle();
                            1.access$200(this.this$0).setCursor(target.getCursor());
                        } else {
                            1.access$200(this.this$0).setCursor(DragCursors.getCursor(0));
                        }
                        if (1.access$300(this.this$0)) {
                            Rectangle[] currentRectangles;
                            if (snapTarget == null) {
                                snapTarget = new Rectangle(1.access$400(this.this$0).x + location.x - 1.access$500(this.this$0).x, 1.access$400(this.this$0).y + location.y - 1.access$500(this.this$0).y, 1.access$400(this.this$0).width, 1.access$400(this.this$0).height);
                            }
                            if ((currentRectangles = 1.access$200(this.this$0).getRectangles()).length != 1 || !currentRectangles[0].equals((Object)snapTarget)) {
                                1.access$200(this.this$0).setRectangles(new Rectangle[]{snapTarget});
                            }
                        }
                    }
                });
            }

            static /* synthetic */ Display access$000(1 x0) {
                return x0.display;
            }

            static /* synthetic */ Object access$100(1 x0) {
                return x0.draggedItem;
            }

            static /* synthetic */ Tracker access$200(1 x0) {
                return x0.tracker;
            }

            static /* synthetic */ boolean access$300(1 x0) {
                return x0.allowSnapping;
            }

            static /* synthetic */ Rectangle access$400(1 x0) {
                return x0.sourceBounds;
            }

            static /* synthetic */ Point access$500(1 x0) {
                return x0.initialLocation;
            }
        });
        if (sourceBounds != null) {
            tracker.setRectangles(new Rectangle[]{new Rectangle(sourceBounds.x, sourceBounds.y, sourceBounds.width, sourceBounds.height)});
        }
        if ((startControl = display.getCursorControl()) != null) {
            startControl.setCapture(true);
        }
        boolean trackingOk = tracker.open();
        if (startControl != null) {
            startControl.setCapture(false);
        }
        Point finalLocation = display.getCursorLocation();
        IDropTarget dropTarget = null;
        if (trackingOk) {
            Control targetControl = display.getCursorControl();
            dropTarget = DragUtil.getDropTarget(targetControl, draggedItem, finalLocation, tracker.getRectangles()[0]);
        }
        tracker.dispose();
        return dropTarget;
    }

    private static IDropTarget getDropTarget(List toSearch, Control mostSpecificControl, Object draggedObject, Point position, Rectangle dragRectangle) {
        if (toSearch == null) {
            return null;
        }
        Iterator iter = toSearch.iterator();
        while (iter.hasNext()) {
            IDragOverListener next = (IDragOverListener)iter.next();
            IDropTarget dropTarget = next.drag(mostSpecificControl, draggedObject, position, dragRectangle);
            if (dropTarget == null) continue;
            return dropTarget;
        }
        return null;
    }

    public static IDropTarget getDropTarget(Control toSearch, Object draggedObject, Point position, Rectangle dragRectangle) {
        for (Control current = toSearch; current != null; current = current.getParent()) {
            IDropTarget dropTarget = DragUtil.getDropTarget(DragUtil.getTargetList(current), toSearch, draggedObject, position, dragRectangle);
            if (dropTarget != null) {
                return dropTarget;
            }
            if (current instanceof Shell) break;
        }
        return DragUtil.getDropTarget(defaultTargets, toSearch, draggedObject, position, dragRectangle);
    }

    public static Point getEventLoc(Event event) {
        Control ctrl = (Control)event.widget;
        return ctrl.toDisplay(new Point(event.x, event.y));
    }
}

