/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.IObjectActionContributor;
import org.eclipse.ui.internal.IObjectContributor;
import org.eclipse.ui.internal.LegacyResourceSupport;
import org.eclipse.ui.internal.ObjectActionContributorReader;
import org.eclipse.ui.internal.ObjectContributorManager;

public class ObjectActionContributorManager
extends ObjectContributorManager {
    private static ObjectActionContributorManager sharedInstance;

    public ObjectActionContributorManager() {
        this.loadContributors();
    }

    private List computeCombinedOrder(Class inputClass) {
        ArrayList result = new ArrayList(4);
        for (Class clazz = inputClass; clazz != null; clazz = clazz.getSuperclass()) {
            result.add(clazz);
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                result.add(interfaces[i]);
            }
        }
        return result;
    }

    public boolean contributeObjectActions(IWorkbenchPart part, IMenuManager popupMenu, ISelectionProvider selProv) {
        IObjectActionContributor contributor;
        int i;
        List results;
        int i2;
        ISelection selection = selProv.getSelection();
        if (selection == null) {
            return false;
        }
        ArrayList<ISelection> elements = null;
        if (selection instanceof IStructuredSelection) {
            elements = ((IStructuredSelection)selection).toList();
        } else {
            elements = new ArrayList<ISelection>(1);
            elements.add(selection);
        }
        List commonClasses = this.getCommonClasses(elements);
        if (commonClasses == null || commonClasses.isEmpty()) {
            return false;
        }
        Class resourceClass = this.getCommonResourceClass(elements);
        List contributors = null;
        if (resourceClass == null) {
            if (commonClasses.size() == 1) {
                contributors = this.getContributors((Class)commonClasses.get(0));
            } else {
                contributors = new ArrayList();
                for (i2 = 0; i2 < commonClasses.size(); ++i2) {
                    results = this.getContributors((Class)commonClasses.get(i2));
                    if (results == null) continue;
                    contributors.addAll(results);
                }
            }
        } else {
            contributors = this.getContributors((Class)commonClasses.get(0), resourceClass);
            for (i2 = 1; i2 < commonClasses.size(); ++i2) {
                results = this.getContributors((Class)commonClasses.get(i2));
                if (results == null) continue;
                contributors.addAll(results);
            }
        }
        if (contributors == null || contributors.isEmpty()) {
            return false;
        }
        boolean actualContributions = false;
        ArrayList overrides = new ArrayList(4);
        for (i = 0; i < contributors.size(); ++i) {
            contributor = (IObjectActionContributor)contributors.get(i);
            if (!this.isApplicableTo(elements, (IObjectContributor)contributor)) continue;
            if (contributor.contributeObjectMenus(popupMenu, selProv)) {
                actualContributions = true;
            }
            contributor.contributeObjectActionIdOverrides(overrides);
        }
        for (i = 0; i < contributors.size(); ++i) {
            contributor = (IObjectActionContributor)contributors.get(i);
            if (!this.isApplicableTo(elements, (IObjectContributor)contributor) || !contributor.contributeObjectActions(part, popupMenu, selProv, overrides)) continue;
            actualContributions = true;
        }
        return actualContributions;
    }

    private Class getCommonClass(Class class1, Class class2) {
        List list1 = this.computeCombinedOrder(class1);
        List list2 = this.computeCombinedOrder(class2);
        for (int i = 0; i < list1.size(); ++i) {
            for (int j = 0; j < list2.size(); ++j) {
                Class candidate2;
                Class candidate1 = (Class)list1.get(i);
                if (!candidate1.equals(candidate2 = (Class)list2.get(j))) continue;
                return candidate1;
            }
        }
        return null;
    }

    private Class getCommonClass(List objects) {
        if (objects == null || objects.size() == 0) {
            return null;
        }
        Class commonClass = objects.get(0).getClass();
        if (objects.size() == 1) {
            return commonClass;
        }
        for (int i = 1; i < objects.size(); ++i) {
            Object object = objects.get(i);
            Class<?> newClass = object.getClass();
            if (newClass.equals(commonClass) || (commonClass = this.getCommonClass(commonClass, newClass)) != null) continue;
            return null;
        }
        return commonClass;
    }

    private List getCommonClasses(List objects) {
        int j;
        if (objects == null || objects.size() == 0) {
            return null;
        }
        if (objects.size() == 1) {
            ArrayList results = new ArrayList(1);
            results.add(objects.get(0).getClass());
            return results;
        }
        List classes = this.computeClassOrder(objects.get(0).getClass());
        List interfaces = this.computeInterfaceOrder(classes);
        boolean classesEmpty = classes.isEmpty();
        boolean interfacesEmpty = interfaces.isEmpty();
        for (int i = 1; i < objects.size(); ++i) {
            List results = this.computeClassOrder(objects.get(i).getClass());
            if (!classesEmpty) {
                classesEmpty = true;
                if (results.isEmpty()) {
                    classes.clear();
                } else {
                    for (j = 0; j < classes.size(); ++j) {
                        if (classes.get(j) == null) continue;
                        classesEmpty = false;
                        if (results.contains(classes.get(j))) continue;
                        classes.set(j, null);
                    }
                }
            }
            if (!interfacesEmpty) {
                results = this.computeInterfaceOrder(results);
                interfacesEmpty = true;
                if (results.isEmpty()) {
                    interfaces.clear();
                } else {
                    for (j = 0; j < interfaces.size(); ++j) {
                        if (interfaces.get(j) == null) continue;
                        interfacesEmpty = false;
                        if (results.contains(interfaces.get(j))) continue;
                        interfaces.set(j, null);
                    }
                }
            }
            if (!interfacesEmpty || !classesEmpty) continue;
            return null;
        }
        ArrayList results = new ArrayList(4);
        ArrayList superClasses = new ArrayList(4);
        if (!classesEmpty) {
            for (j = 0; j < classes.size(); ++j) {
                if (classes.get(j) == null) continue;
                superClasses.add(classes.get(j));
            }
            if (!superClasses.isEmpty()) {
                results.add(superClasses.get(0));
            }
        }
        if (!interfacesEmpty) {
            List dropInterfaces = null;
            if (!superClasses.isEmpty()) {
                dropInterfaces = this.computeInterfaceOrder(superClasses);
            }
            for (int j2 = 0; j2 < interfaces.size(); ++j2) {
                if (interfaces.get(j2) == null || dropInterfaces == null || dropInterfaces.contains(interfaces.get(j2))) continue;
                results.add(interfaces.get(j2));
            }
        }
        return results;
    }

    public static ObjectActionContributorManager getManager() {
        if (sharedInstance == null) {
            sharedInstance = new ObjectActionContributorManager();
        }
        return sharedInstance;
    }

    private void loadContributors() {
        ObjectActionContributorReader reader = new ObjectActionContributorReader();
        reader.readPopupContributors(this);
    }

    private Class getCommonResourceClass(List objects) {
        if (objects == null || objects.size() == 0) {
            return null;
        }
        Class resourceClass = LegacyResourceSupport.getResourceClass();
        if (resourceClass == null) {
            return null;
        }
        ArrayList<Object> testList = new ArrayList<Object>();
        for (int i = 0; i < objects.size(); ++i) {
            Object object = objects.get(i);
            if (object instanceof IAdaptable) {
                if (resourceClass.isInstance(object)) continue;
                Object resource = this.getAdaptedResource((IAdaptable)object);
                if (resource == null) {
                    return null;
                }
                testList.add(resource);
                continue;
            }
            return null;
        }
        return this.getCommonClass(testList);
    }
}

