/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XEvent;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    Composite parent;
    boolean tracking;
    boolean stippled;
    Rectangle[] rectangles;
    Rectangle[] proportions;
    Rectangle bounds;
    int cursorOrientation = 0;
    int cursor;
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;

    public Tracker(Composite parent, int style) {
        super(parent, Tracker.checkStyle(style));
        this.parent = parent;
    }

    public Tracker(Display display, int style) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Tracker.checkStyle(style);
        this.display = display;
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    Point adjustMoveCursor(int xDisplay, int xWindow) {
        int[] unused = new int[1];
        int[] actualX = new int[1];
        int[] actualY = new int[1];
        int newX = this.bounds.x + this.bounds.width / 2;
        int newY = this.bounds.y;
        OS.XWarpPointer(xDisplay, 0, xWindow, 0, 0, 0, 0, newX, newY);
        OS.XQueryPointer(xDisplay, xWindow, unused, unused, actualX, actualY, unused, unused, unused);
        return new Point(actualX[0], actualY[0]);
    }

    Point adjustResizeCursor(int xDisplay, int xWindow) {
        int newX = (this.cursorOrientation & 0x4000) != 0 ? this.bounds.x : ((this.cursorOrientation & 0x20000) != 0 ? this.bounds.x + this.bounds.width : this.bounds.x + this.bounds.width / 2);
        int newY = (this.cursorOrientation & 0x80) != 0 ? this.bounds.y : ((this.cursorOrientation & 0x400) != 0 ? this.bounds.y + this.bounds.height : this.bounds.y + this.bounds.height / 2);
        int[] unused = new int[1];
        int[] actualX = new int[1];
        int[] actualY = new int[1];
        OS.XWarpPointer(xDisplay, 0, xWindow, 0, 0, 0, 0, newX, newY);
        OS.XQueryPointer(xDisplay, xWindow, unused, unused, actualX, actualY, unused, unused, unused);
        return new Point(actualX[0], actualY[0]);
    }

    static int checkStyle(int style) {
        if ((style & 0x24480) == 0) {
            style |= 0x24480;
        }
        return style;
    }

    public void close() {
        this.checkWidget();
        this.tracking = false;
    }

    Rectangle computeBounds() {
        int xMin = this.rectangles[0].x;
        int yMin = this.rectangles[0].y;
        int xMax = this.rectangles[0].x + this.rectangles[0].width;
        int yMax = this.rectangles[0].y + this.rectangles[0].height;
        for (int i = 1; i < this.rectangles.length; ++i) {
            int rectBottom;
            int rectRight;
            if (this.rectangles[i].x < xMin) {
                xMin = this.rectangles[i].x;
            }
            if (this.rectangles[i].y < yMin) {
                yMin = this.rectangles[i].y;
            }
            if ((rectRight = this.rectangles[i].x + this.rectangles[i].width) > xMax) {
                xMax = rectRight;
            }
            if ((rectBottom = this.rectangles[i].y + this.rectangles[i].height) <= yMax) continue;
            yMax = rectBottom;
        }
        return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    Rectangle[] computeProportions(Rectangle[] rects) {
        Rectangle[] result = new Rectangle[rects.length];
        this.bounds = this.computeBounds();
        for (int i = 0; i < rects.length; ++i) {
            int x = 0;
            int y = 0;
            int width = 0;
            int height = 0;
            if (this.bounds.width != 0) {
                x = (rects[i].x - this.bounds.x) * 100 / this.bounds.width;
                width = rects[i].width * 100 / this.bounds.width;
            } else {
                width = 100;
            }
            if (this.bounds.height != 0) {
                y = (rects[i].y - this.bounds.y) * 100 / this.bounds.height;
                height = rects[i].height * 100 / this.bounds.height;
            } else {
                height = 100;
            }
            result[i] = new Rectangle(x, y, width, height);
        }
        return result;
    }

    void drawRectangles(Rectangle[] rects, boolean stippled) {
        if (this.parent != null) {
            if (this.parent.isDisposed()) {
                return;
            }
            this.parent.getShell().update();
        } else {
            this.display.update();
        }
        int xDisplay = this.display.xDisplay;
        int color = OS.XWhitePixel(xDisplay, 0);
        int xWindow = OS.XDefaultRootWindow(xDisplay);
        if (this.parent != null) {
            xWindow = OS.XtWindow(this.parent.handle);
            if (xWindow == 0) {
                return;
            }
            int[] argList = new int[]{OS.XmNforeground, 0, OS.XmNbackground, 0};
            OS.XtGetValues(this.parent.handle, argList, argList.length / 2);
            color = argList[1] ^ argList[3];
        }
        int gc = OS.XCreateGC(xDisplay, xWindow, 0, null);
        OS.XSetForeground(xDisplay, gc, color);
        OS.XSetSubwindowMode(xDisplay, gc, 1);
        OS.XSetFunction(xDisplay, gc, 6);
        int stipplePixmap = 0;
        if (stippled) {
            byte[] bits = new byte[]{-86, 0, 85, 0, -86, 0, 85, 0, -86, 0, 85, 0, -86, 0, 85, 0};
            stipplePixmap = OS.XCreateBitmapFromData(xDisplay, xWindow, bits, 8, 8);
            OS.XSetStipple(xDisplay, gc, stipplePixmap);
            OS.XSetFillStyle(xDisplay, gc, 2);
            OS.XSetLineAttributes(xDisplay, gc, 3, 0, 1, 0);
        }
        for (int i = 0; i < rects.length; ++i) {
            Rectangle rect = rects[i];
            OS.XDrawRectangle(xDisplay, xWindow, gc, rect.x, rect.y, rect.width, rect.height);
        }
        if (stippled) {
            OS.XFreePixmap(xDisplay, stipplePixmap);
        }
        OS.XFreeGC(xDisplay, gc);
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        int length = 0;
        if (this.rectangles != null) {
            length = this.rectangles.length;
        }
        Rectangle[] result = new Rectangle[length];
        for (int i = 0; i < length; ++i) {
            Rectangle current = this.rectangles[i];
            result[i] = new Rectangle(current.x, current.y, current.width, current.height);
        }
        return result;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    void moveRectangles(int xChange, int yChange) {
        if (xChange < 0 && (this.style & 0x4000) == 0) {
            xChange = 0;
        }
        if (xChange > 0 && (this.style & 0x20000) == 0) {
            xChange = 0;
        }
        if (yChange < 0 && (this.style & 0x80) == 0) {
            yChange = 0;
        }
        if (yChange > 0 && (this.style & 0x400) == 0) {
            yChange = 0;
        }
        if (xChange == 0 && yChange == 0) {
            return;
        }
        this.bounds.x += xChange;
        this.bounds.y += yChange;
        for (int i = 0; i < this.rectangles.length; ++i) {
            this.rectangles[i].x += xChange;
            this.rectangles[i].y += yChange;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean open() {
        this.checkWidget();
        if (this.rectangles == null) {
            return false;
        }
        xDisplay = this.display.xDisplay;
        xWindow = OS.XDefaultRootWindow(xDisplay);
        if (this.parent != null && (xWindow = OS.XtWindow(this.parent.handle)) == 0) {
            return false;
        }
        cancelled = false;
        this.tracking = true;
        this.drawRectangles(this.rectangles, this.stippled);
        oldX = new int[1];
        oldY = new int[1];
        unused = new int[1];
        mask = new int[1];
        OS.XQueryPointer(xDisplay, xWindow, unused, unused, oldX, oldY, unused, unused, mask);
        vStyle = this.style & 1152;
        if (vStyle == 128 || vStyle == 1024) {
            this.cursorOrientation |= vStyle;
        }
        if ((hStyle = this.style & 147456) == 16384 || hStyle == 131072) {
            this.cursorOrientation |= hStyle;
        }
        v0 = mouseDown = (mask[0] & (mouseMasks = 1792)) != 0;
        if (!mouseDown) {
            cursorPos = (this.style & 16) != 0 ? this.adjustResizeCursor(xDisplay, xWindow) : this.adjustMoveCursor(xDisplay, xWindow);
            oldX[0] = cursorPos.x;
            oldY[0] = cursorPos.y;
        }
        xEvent = OS.XtMalloc(96);
        anyEvent = new XEvent();
        newX = new int[1];
        newY = new int[1];
        xtContext = OS.XtDisplayToApplicationContext(xDisplay);
        ptrGrabResult = OS.XGrabPointer(xDisplay, xWindow, 0, 76, 1, 1, 0, 0, 0);
        kbdGrabResult = OS.XGrabKeyboard(xDisplay, xWindow, 0, 1, 1, 0);
        block14: while (this.tracking && (this.parent == null || !this.parent.isDisposed())) {
            OS.XtAppNextEvent(xtContext, xEvent);
            OS.memmove(anyEvent, xEvent, 96);
            switch (anyEvent.type) {
                case 6: {
                    if (this.cursor != 0) {
                        OS.XChangeActivePointerGrab(xDisplay, 76, this.cursor, 0);
                    }
                }
                case 5: {
                    OS.XQueryPointer(xDisplay, xWindow, unused, unused, newX, newY, unused, unused, unused);
                    if (oldX[0] == newX[0] && oldY[0] == newY[0]) ** GOTO lbl103
                    oldRectangles = this.rectangles;
                    oldStippled = this.stippled;
                    rectsToErase = new Rectangle[this.rectangles.length];
                    for (i = 0; i < this.rectangles.length; ++i) {
                        current = this.rectangles[i];
                        rectsToErase[i] = new Rectangle(current.x, current.y, current.width, current.height);
                    }
                    event = new Event();
                    event.x = newX[0];
                    event.y = newY[0];
                    if ((this.style & 16) == 0) ** GOTO lbl81
                    this.resizeRectangles(newX[0] - oldX[0], newY[0] - oldY[0]);
                    this.sendEvent(11, event);
                    if (this.isDisposed()) {
                        cancelled = true;
                        continue block14;
                    }
                    draw = false;
                    if (this.rectangles == oldRectangles) ** GOTO lbl73
                    length = this.rectangles.length;
                    if (length == rectsToErase.length) ** GOTO lbl68
                    draw = true;
                    ** GOTO lbl74
lbl68:
                    // 2 sources

                    for (i = 0; i < length; ++i) {
                        if (this.rectangles[i].equals(rectsToErase[i])) continue;
                        draw = true;
                        ** GOTO lbl74
                    }
                    ** GOTO lbl74
lbl73:
                    // 1 sources

                    draw = true;
lbl74:
                    // 4 sources

                    if (draw) {
                        this.drawRectangles(rectsToErase, oldStippled);
                        this.drawRectangles(this.rectangles, this.stippled);
                    }
                    cursorPos = this.adjustResizeCursor(xDisplay, xWindow);
                    newX[0] = cursorPos.x;
                    newY[0] = cursorPos.y;
                    ** GOTO lbl101
lbl81:
                    // 1 sources

                    this.moveRectangles(newX[0] - oldX[0], newY[0] - oldY[0]);
                    this.sendEvent(10, event);
                    if (this.isDisposed()) {
                        cancelled = true;
                        continue block14;
                    }
                    draw = false;
                    if (this.rectangles == oldRectangles) ** GOTO lbl97
                    length = this.rectangles.length;
                    if (length == rectsToErase.length) ** GOTO lbl92
                    draw = true;
                    ** GOTO lbl98
lbl92:
                    // 2 sources

                    for (i = 0; i < length; ++i) {
                        if (this.rectangles[i].equals(rectsToErase[i])) continue;
                        draw = true;
                        ** GOTO lbl98
                    }
                    ** GOTO lbl98
lbl97:
                    // 1 sources

                    draw = true;
lbl98:
                    // 4 sources

                    if (draw) {
                        this.drawRectangles(rectsToErase, oldStippled);
                        this.drawRectangles(this.rectangles, this.stippled);
                    }
lbl101:
                    // 4 sources

                    oldX[0] = newX[0];
                    oldY[0] = newY[0];
lbl103:
                    // 2 sources

                    this.tracking = anyEvent.type != 5;
                    continue block14;
                }
                case 2: {
                    keyEvent = new XKeyEvent();
                    OS.memmove(keyEvent, xEvent, 60);
                    if (keyEvent.keycode == 0) continue block14;
                    keysym = new int[1];
                    OS.XLookupString(keyEvent, null, 0, keysym, null);
                    keysym[0] = keysym[0] & 65535;
                    xChange = 0;
                    yChange = 0;
                    stepSize = (keyEvent.state & 4) != 0 ? 1 : 9;
                    switch (keysym[0]) {
                        case 65293: 
                        case 65421: {
                            this.tracking = false;
                            OS.XtAppNextEvent(xtContext, xEvent);
                            break;
                        }
                        case 65307: {
                            this.tracking = false;
                            cancelled = true;
                            OS.XtAppNextEvent(xtContext, xEvent);
                            break;
                        }
                        case 65361: {
                            xChange = -stepSize;
                            break;
                        }
                        case 65363: {
                            xChange = stepSize;
                            break;
                        }
                        case 65362: {
                            yChange = -stepSize;
                            break;
                        }
                        case 65364: {
                            yChange = stepSize;
                        }
                    }
                    if (xChange == 0 && yChange == 0) continue block14;
                    oldRectangles = this.rectangles;
                    oldStippled = this.stippled;
                    rectsToErase = new Rectangle[this.rectangles.length];
                    for (i = 0; i < this.rectangles.length; ++i) {
                        current = this.rectangles[i];
                        rectsToErase[i] = new Rectangle(current.x, current.y, current.width, current.height);
                    }
                    event = new Event();
                    event.x = oldX[0] + xChange;
                    event.y = oldY[0] + yChange;
                    if ((this.style & 16) == 0) ** GOTO lbl171
                    this.resizeRectangles(xChange, yChange);
                    this.sendEvent(11, event);
                    if (this.isDisposed()) {
                        cancelled = true;
                        continue block14;
                    }
                    draw = false;
                    if (this.rectangles == oldRectangles) ** GOTO lbl165
                    length = this.rectangles.length;
                    if (length == rectsToErase.length) ** GOTO lbl160
                    draw = true;
                    ** GOTO lbl166
lbl160:
                    // 2 sources

                    for (i = 0; i < length; ++i) {
                        if (this.rectangles[i].equals(rectsToErase[i])) continue;
                        draw = true;
                        ** GOTO lbl166
                    }
                    ** GOTO lbl166
lbl165:
                    // 1 sources

                    draw = true;
lbl166:
                    // 4 sources

                    if (draw) {
                        this.drawRectangles(rectsToErase, oldStippled);
                        this.drawRectangles(this.rectangles, this.stippled);
                    }
                    cursorPos = this.adjustResizeCursor(xDisplay, xWindow);
                    ** GOTO lbl192
lbl171:
                    // 1 sources

                    this.moveRectangles(xChange, yChange);
                    this.sendEvent(10, event);
                    if (this.isDisposed()) {
                        cancelled = true;
                        continue block14;
                    }
                    draw = false;
                    if (this.rectangles == oldRectangles) ** GOTO lbl187
                    length = this.rectangles.length;
                    if (length == rectsToErase.length) ** GOTO lbl182
                    draw = true;
                    ** GOTO lbl188
lbl182:
                    // 2 sources

                    for (i = 0; i < length; ++i) {
                        if (this.rectangles[i].equals(rectsToErase[i])) continue;
                        draw = true;
                        ** GOTO lbl188
                    }
                    ** GOTO lbl188
lbl187:
                    // 1 sources

                    draw = true;
lbl188:
                    // 4 sources

                    if (draw) {
                        this.drawRectangles(rectsToErase, oldStippled);
                        this.drawRectangles(this.rectangles, this.stippled);
                    }
                    cursorPos = this.adjustMoveCursor(xDisplay, xWindow);
lbl192:
                    // 2 sources

                    oldX[0] = cursorPos.x;
                    oldY[0] = cursorPos.y;
                    continue block14;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    continue block14;
                }
            }
            OS.XtDispatchEvent(xEvent);
        }
        OS.XtFree(xEvent);
        if (!this.isDisposed()) {
            this.drawRectangles(this.rectangles, this.stippled);
        }
        if (ptrGrabResult == 0) {
            OS.XUngrabPointer(xDisplay, 0);
        }
        if (kbdGrabResult == 0) {
            OS.XUngrabKeyboard(xDisplay, 0);
        }
        return cancelled == false;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(11, listener);
        this.eventTable.unhook(10, listener);
    }

    void resizeRectangles(int xChange, int yChange) {
        Rectangle proportion;
        int i;
        if (xChange < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x4000;
        } else if (xChange > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x20000;
        } else if (yChange < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x80;
        } else if (yChange > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x400;
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            if (xChange > this.bounds.width) {
                if ((this.style & 0x20000) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x20000;
                this.cursorOrientation &= 0xFFFFBFFF;
                this.bounds.x += this.bounds.width;
                xChange -= this.bounds.width;
                this.bounds.width = 0;
                if (this.proportions.length > 1) {
                    for (i = 0; i < this.proportions.length; ++i) {
                        proportion = this.proportions[i];
                        proportion.x = 100 - proportion.x - proportion.width;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x20000) != 0 && this.bounds.width < -xChange) {
            if ((this.style & 0x4000) == 0) {
                return;
            }
            this.cursorOrientation |= 0x4000;
            this.cursorOrientation &= 0xFFFDFFFF;
            xChange += this.bounds.width;
            this.bounds.width = 0;
            if (this.proportions.length > 1) {
                for (i = 0; i < this.proportions.length; ++i) {
                    proportion = this.proportions[i];
                    proportion.x = 100 - proportion.x - proportion.width;
                }
            }
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            if (yChange > this.bounds.height) {
                if ((this.style & 0x400) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x400;
                this.cursorOrientation &= 0xFFFFFF7F;
                this.bounds.y += this.bounds.height;
                yChange -= this.bounds.height;
                this.bounds.height = 0;
                if (this.proportions.length > 1) {
                    for (i = 0; i < this.proportions.length; ++i) {
                        proportion = this.proportions[i];
                        proportion.y = 100 - proportion.y - proportion.height;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x400) != 0 && this.bounds.height < -yChange) {
            if ((this.style & 0x80) == 0) {
                return;
            }
            this.cursorOrientation |= 0x80;
            this.cursorOrientation &= 0xFFFFFBFF;
            yChange += this.bounds.height;
            this.bounds.height = 0;
            if (this.proportions.length > 1) {
                for (i = 0; i < this.proportions.length; ++i) {
                    proportion = this.proportions[i];
                    proportion.y = 100 - proportion.y - proportion.height;
                }
            }
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            this.bounds.x += xChange;
            this.bounds.width -= xChange;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            this.bounds.width += xChange;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            this.bounds.y += yChange;
            this.bounds.height -= yChange;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            this.bounds.height += yChange;
        }
        Rectangle[] newRects = new Rectangle[this.rectangles.length];
        for (int i2 = 0; i2 < this.rectangles.length; ++i2) {
            Rectangle proportion2 = this.proportions[i2];
            newRects[i2] = new Rectangle(proportion2.x * this.bounds.width / 100 + this.bounds.x, proportion2.y * this.bounds.height / 100 + this.bounds.y, proportion2.width * this.bounds.width / 100, proportion2.height * this.bounds.height / 100);
        }
        this.rectangles = newRects;
    }

    public void setCursor(Cursor value) {
        this.checkWidget();
        this.cursor = 0;
        if (value != null) {
            this.cursor = value.handle;
        }
    }

    public void setRectangles(Rectangle[] rectangles) {
        this.checkWidget();
        if (rectangles == null) {
            this.error(4);
        }
        int length = rectangles.length;
        this.rectangles = new Rectangle[length];
        for (int i = 0; i < length; ++i) {
            Rectangle current = rectangles[i];
            if (current == null) {
                this.error(4);
            }
            this.rectangles[i] = new Rectangle(current.x, current.y, current.width, current.height);
        }
        this.proportions = this.computeProportions(rectangles);
    }

    public void setStippled(boolean stippled) {
        this.checkWidget();
        this.stippled = stippled;
    }
}

